//          Warp Communications Library
//          Copyright (C) 1991 Trevor Bell, All Rights Reserved

#define MK_INT(high, low) ((((unsigned int)(high)) << 8) + ((unsigned int)(low)))

class COM_port {
    volatile unsigned char *receive_buffer;
    volatile unsigned char *xmit_buffer;

    unsigned int receive_buffer_size;
    unsigned int xmit_buffer_size;

    volatile unsigned int xmit_tail, xmit_head;
    volatile unsigned int receive_tail, receive_head;
    unsigned int
    base,       // base register
    ier_reg,    // interrupt enable register
    iir_reg,    // interrupt identification register
    lcr_reg,    // line control register
    mcr_reg,    // modem control register
    lsr_reg,    // line status register
    msr_reg;    // modem status register

    unsigned int port_num;
    void interrupt (far *old_async)(...);

public:
    int CD;
    unsigned int async_irq;
    unsigned int com_baudrate;
    void isr(void);
    void set_baudrate(unsigned int baud_rate);
    int char_waiting(void);
    void send_modem_string(char *s);
    void set_rts(unsigned int i);
    void set_dtr(unsigned int i);
    void purge_receive_buffer(void);
    void purge_xmit_buffer(void);
    void open(unsigned int port, unsigned int baud_rate, unsigned int irq,
        unsigned int base_address, unsigned int r_size, unsigned int x_size);
    void close(void);
    void out_buf(unsigned char *s, unsigned int length);
    void get_buf(unsigned char *s, unsigned int length);
    unsigned char read_ier (void);
    unsigned char read_lcr (void);
    unsigned char read_mcr (void);
    unsigned char read_lsr (void);
    unsigned char read_msr (void);
    COM_port& operator<< (char ch1);
    COM_port& operator<< (unsigned char ch1);
    COM_port& operator<< (char *s);
    COM_port& operator<< (unsigned int &s);
    COM_port& operator>> (char &ch1);
    COM_port& operator>> (unsigned char &ch1);
    COM_port& operator>> (unsigned int &s);
    COM_port& operator>> (char *s);
    COM_port(void);
};

void interrupt far normal_async_isr0(...);
void interrupt far normal_async_isr1(...);
void interrupt far normal_async_isr2(...);
void interrupt far normal_async_isr3(...);
void interrupt far normal_async_isr4(...);
void interrupt far normal_async_isr5(...);
void interrupt far normal_async_isr6(...);
void interrupt far normal_async_isr7(...);
