//          Warp Communications Library
//          Copyright (C) 1991 Trevor Bell, All Rights Reserved


#include <conio.h>
#include <stdio.h>
#include <process.h>
#include <iostream.h>
#include "warpcomm.hpp"

extern COM_port remote[8];

int main(void)
{
    char ch=0, ch2=0;
    clrscr();
    cout << "A simple terminal program for the Warp Communications Library (Ctrl-C to exit)\r\n";
    cout << "Copyright (C) 1991 Trevor Bell, All Rights Reserved\r\n\n";

    remote[0].open(0, 2400, 4, 0x3f8, 2000, 2000);
    // opens com port 1 at 2400 baud, IRQ 4, base address 3F8 (hex) with
    // 2000 byte transmit and receive buffers

    remote[0].send_modem_string("ATZ|");
    // initialize the modem

    while(ch != 3) {
        if(kbhit()) {           // checks for a keypress
            ch=getch();         // gets a keypress
            remote[0] << ch;       // sends a character to the com port
        }
        if(remote[0].char_waiting()) {
        // checks to see if a character is waiting at the com port

            remote[0] >> ch2;      // gets a character from the com port
            putch(ch2);         // outputs the character onto the screen
        }
    }
    remote[0].close();             // closes the com port
    exit(0);                    // exits with errorlevel 0
}
