//          Warp Communications Library
//          Copyright (C) 1991 Trevor Bell, All Rights Reserved

#define MK_INT(high, low) ((((unsigned int)(high)) << 8) + ((unsigned int)(low)))

void isr(unsigned int port);
void set_baudrate(unsigned int port, unsigned int baud_rate);
int char_waiting(unsigned int port);
void send_modem_string(unsigned int port, char *s);
void set_rts(unsigned int port, unsigned int i);
void set_dtr(unsigned int port, unsigned int i);
void purge_receive_buffer(unsigned int port);
void purge_xmit_buffer(unsigned int port);
void com_open(unsigned int port, unsigned int baud_rate, unsigned int irq,
    unsigned int base_address, unsigned int r_size, unsigned int x_size);
void com_close(unsigned int port);
void com_out_buf(unsigned int port, unsigned char *s, unsigned int length);
void com_get_buf(unsigned int port, unsigned char *s, unsigned int length);
void com_out_char(unsigned int port, char ch1);
void com_out_uchar(unsigned int port, unsigned char ch1);
void com_out_char_str(unsigned int port, char *s);
char com_get_char(unsigned int port);
unsigned char com_get_uchar(unsigned int port);
unsigned char read_ier(unsigned int port);
unsigned char read_lsr(unsigned int port);
unsigned char read_msr(unsigned int port);
unsigned char read_lcr(unsigned int port);
unsigned char read_mcr(unsigned int port);

void interrupt far normal_async_isr0();
void interrupt far normal_async_isr1();
void interrupt far normal_async_isr2();
void interrupt far normal_async_isr3();
void interrupt far normal_async_isr4();
void interrupt far normal_async_isr5();
void interrupt far normal_async_isr6();
void interrupt far normal_async_isr7();

struct COM_port {
    volatile unsigned char *receive_buffer;
    volatile unsigned char *xmit_buffer;

    unsigned int receive_buffer_size;
    unsigned int xmit_buffer_size;

    volatile unsigned int xmit_tail, xmit_head;
    volatile unsigned int receive_tail, receive_head;

    int CD;                     // carrier detect
    unsigned int async_irq;     // interrupt request #
    unsigned int com_baudrate;  // current baudrate

    unsigned int
    base,       // base register
    ier_reg,    // interrupt enable register
    iir_reg,    // interrupt identification register
    lcr_reg,    // line control register
    mcr_reg,    // modem control register
    lsr_reg,    // line status register
    msr_reg;    // modem status register

    void interrupt (far *old_async)();
};

extern struct COM_port remote[8];
