/**** VIR.H ****/
/**** Virtual array functions header file ****/

/**** Error flag test bits ****/

#define VFILEerr	0x0001		/* Open/Close error flag bit */
#define VREADerr 	0x0002		/* Read error flag bit */
#define VWRITEerr   	0x0004		/* Write error flag bit */
#define VSEEKerr	0x0008		/* Seek error flag bit */
#define VLOCKerr	0x0010		/* Lock error flag bit */
#define VUNLOCKerr	0x0020		/* Unlock error flag bit */

/**** Option flag test bits ****/

#define VDENYRopt	0x0001		/* Deny others read access */
#define VDENYWopt	0x0002		/* Deny others write access */
#define VCREATopt	0x0004		/* Create file if not exist */
#define VTRUNCopt	0x0008		/* Truncate file upon open */
#define VLOCKSopt	0x0010		/* Lock/unlock active pages */
#define VWRITEopt	0x0020		/* Not read only mode */

/**** Variable type definitions ****/

typedef struct	{int a;int b;} INTS;
typedef union	{long ix;INTS x;} VIX;
typedef struct	{int page;VIX idx;VIX end;} IX;	/* Control structure */

/**** Function definitions ****/

int V_clr(void *BFR,IX X[]);		/* Virtual clear function */
int V_stop(void *BFR,IX X[]);		/* Virtual close down */
int V_init(char *fname,IX X[]);		/* Virtual initialization */
int V_r(long index,void *BFR,IX X[]);	/* Virtual access operator */

/**** Variable macros ****/

#define VNext(n) 	n##_VX[0].page		/* Buffer age pointer */
#define VFile(n) 	n##_VX[0].idx.x.a	/* File handle */
#define VPages(n) 	n##_VX[0].idx.x.b	/* # of pages in buffer */
#define VPlen(n)	n##_VX[0].end.x.a	/* Elements per page */
#define VSize(n)	n##_VX[0].end.x.b	/* Bytes per element */
#define VErr(n)		n##_VX[1].page		/* Error flags of last access */
#define VOffset(n)	n##_VX[1].idx.ix	/* Byte offset of array */
#define VOptions(n)	n##_VX[1].end.x.a	/* File access option flags */
#define VPidx(n)	n##_VX[VNext(n)+2].idx.ix  /* Selected page index */
#define VPend(n)   	n##_VX[VNext(n)+2].end.ix  /* Selected page end */
#define VREF(n,in)\
	((in-VPidx(n))+(n##_VX[VNext(n)+2].page*VPlen(n)))

/**** Operational macros ****/

#define Vdcl(typ,nam,len,pgs)\
	typ nam##_V[len*pgs];\
	IX nam##_VX[pgs+2]=\
	{0,pgs*0x00010000,len+sizeof(typ)*0x00010000}\

#define V_(nm,in)\
	nm##_V[((in>=VPidx(nm)&&in<VPend(nm))?(VErr(nm)=0,VREF(nm,in)):\
		   (V_r(in,nm##_V,nm##_VX)))]

#define Vclr(nam) V_clr(nam##_V,nam##_VX)

#define Vstop(nam) V_stop(nam##_V,nam##_VX)

#define Vinit(name,fnam,ofs,ops)\
	VOffset(name)=ofs;\
	VOptions(name)=ops;\
	V_init(fnam,name##_VX);

