#include <string.h>
#include <vvp.hpp>

char *txt[] = {
	"Port virtual pointer code",
	"between Microsoft Windows",
	"and the rest of the programming",
	"world without change!",
	"Never fuss with a Windows memory",
	"handle again - use vvp!",	
	0
};

#define txtCells sizeof(txt)/sizeof(char *) - 1


typeVP(char);
charVP t[txtCells];
charVFP tfar[txtCells];


void clonetxt()
{
	int i;

	for (i = 0; i < txtCells; i++)
		if (t[i].calloc(strlen(txt[i])+1))  {
			strcpy(t[i],txt[i]);
			(void) t[i].unlock();
		}
	for (i = 0; i < txtCells; i++)
		if (tfar[i].farcalloc(strlen(txt[i])+1)) {
			_fstrncpy(tfar[i],txt[i],
				strlen(txt[i])+1);
			(void) tfar[i].unlock();
		}
}


void freeclonetxt()
{
	int i;

	for (i = 0; i < txtCells; i++)
		t[i].free();
	for (i = 0; i < txtCells; i++)
		tfar[i].farfree();
}




#ifdef _Windows        //  Windows Version

long FAR PASCAL _export WndProc(
	HWND hWnd,
	WORD iMessage,
	WORD wParam,
	LONG lParam );


#pragma argsused
int PASCAL WinMain(
	HANDLE hInstance,
	HANDLE hPrevInstance,
	LPSTR lpszCmdLine,
	int cmdShow)
{
	HWND hwnd;
	MSG  msg;
	WNDCLASS wndclass;

	if (!hPrevInstance)  {
		wndclass.lpszClassName = "HPVOID:MAIN";
		wndclass.hInstance = hInstance;
		wndclass.lpfnWndProc = WndProc;
		wndclass.hCursor = LoadCursor(NULL,IDC_ARROW);
		wndclass.hIcon = LoadIcon(NULL,IDI_APPLICATION);
		wndclass.lpszMenuName = NULL;
		wndclass.hbrBackground = COLOR_WINDOW+1;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		RegisterClass(&wndclass);
	}
	hwnd = CreateWindow("HPVOID:MAIN","Universal Handle/Pointer",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		0,
		CW_USEDEFAULT,
		0,
		NULL,
		NULL,
		hInstance,
		NULL);
	ShowWindow(hwnd,cmdShow);
	while (GetMessage(&msg,0,0,0))  {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return 0;
}



long FAR PASCAL WndProc(
	HWND hWnd,
	WORD iMessage,
	WORD wParam,
	LONG lParam )
{
	int i, x, y;
	PAINTSTRUCT ps;
	TEXTMETRIC tmSys;

	switch (iMessage)  {
		case WM_CREATE:
			clonetxt();
			break;
		case WM_PAINT:
			BeginPaint(hWnd,&ps);
			GetTextMetrics(ps.hdc,&tmSys);
			x = tmSys.tmAveCharWidth * 2;
			y = tmSys.tmHeight;
			for (i = 0; i < txtCells; i++)  {
				TextOut(ps.hdc,x,y,t[i],
					strlen(t[i]));
				t[i].unlock();
				y += tmSys.tmHeight * 2;
			}
			y += tmSys.tmHeight * 2;
			for (i = 0; i < txtCells; i++)  {
				TextOut(ps.hdc,x,y,tfar[i],
					_fstrlen(tfar[i]));
				tfar[i].unlock();
				y += tmSys.tmHeight * 2;
			}
			EndPaint(hWnd,&ps);
			break;
		case WM_DESTROY:
			freeclonetxt();
			PostQuitMessage(0);
			break;
		default:
			return (DefWindowProc(hWnd,iMessage,wParam,lParam));
	}
	return 0L;
}




#else  // Non Windows Version

#include <iostream.h>
#include <iomanip.h>

main()
{
	int i, j;

	clonetxt();
	for (i = 0; i < txtCells; i++)  {
		cout << t[i] << endl;
		(void) t[i].unlock();
	}
	cout << endl;
	for (i = 0; i < txtCells; i++)  {
		for (j = 0; tfar[i][j]; j++)
			cout << tfar[i][j];
		cout << endl;
		(void) tfar[i].unlock();
	}

	freeclonetxt();
}

#endif


