/*

	vvp.hpp
	6-4-91
	void virtual pointer

	Copyright 1991
	John W. Small
	All rights reserved
	CIS: 73757,2233

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072
	USA (703) 759-3838


*/

#ifndef VOIDVP_HPP
#define VOIDVP_HPP


#if defined(__TINY__)
#error voidVFP precludes the use of the Tiny Memory Model!
#endif

#ifdef _Windows             // Windows Application


#include <windows.h>
#include <stddef.h>
#include <dos.h>  // MK_FP(), FP_SEG()

class voidVP {
protected:
	HANDLE hp;
	void *p;
public:
	voidVP() { hp = NULL; p = (void *) 0; }
	unsigned locks()
	{
		return (hp? (LocalFlags(hp)
			& LMEM_LOCKCOUNT) : 0);
	}
	int  lock()
	{
		return (hp? ((p =
#if defined(__SMALL__) || defined(__MEDIUM__)
		LocalLock(hp)
#else
		MK_FP(_DS,(unsigned)LocalLock(hp))
#endif
			) != (void *) 0) : 0);
	}
	int  unlock()
	{
		int l;

		if (!hp)
			return 0;
		if ((l = LocalUnlock(hp)) == 0)
			p = (void *) 0;
		return l;
	}
	operator void *()
	{
		if (!p)
			lock();
		return p;
	}
	voidVP& operator=(void *p)
		{ hp = NULL; this->p = p; return *this; }
	int malloc(size_t size)
	{
		p = (void *) 0;
		return ((hp = LocalAlloc
			(LMEM_MOVEABLE,size)) != NULL);
	}
	int calloc(size_t nobj, size_t size)
	{
		p = (void *) 0;
		return ((hp = LocalAlloc
			(LMEM_MOVEABLE | LMEM_ZEROINIT,
			nobj*size)) != NULL);
	}
	int realloc(size_t size);
	void free();
};

class FarHeapManager {
	unsigned sizeofFarHeaps;
	unsigned subAllocThreshold;
	HANDLE hFarHeap;
public:
	FarHeapManager(unsigned size = 8192,
		unsigned threshold = 1024)
	{
		sizeofFarHeaps = size;
		subAllocThreshold = threshold;
		hFarHeap = NULL;
	}
	unsigned SubAllocThreshold()
		{ return subAllocThreshold; }
	unsigned locks(HANDLE hseg, HANDLE hofs);
	void far * lock(HANDLE hseg, HANDLE hofs);
	int unlock(HANDLE hseg, HANDLE hofs);
	int farmalloc(unsigned long nbytes, HANDLE *hseg,
		 HANDLE *hofs,
		 unsigned gflags = GMEM_MOVEABLE,
		 unsigned lflags = LMEM_MOVEABLE);
	int farrealloc(unsigned long nbytes, HANDLE *hseg,
		HANDLE *hofs);
	void farfree(HANDLE hseg, HANDLE hofs);
};

extern FarHeapManager FHeap;  // Only instance!

class voidVFP {
protected:
	HANDLE hseg, hofs;
	void far *p;
public:
	voidVFP()
	{
		hseg = hofs = NULL;
		p = (void far *) 0;

	}
	unsigned locks()
	{
		return FHeap.locks(hseg,hofs);
	}
	int  lock()
	{
		return ((p = FHeap.lock(hseg,hofs))
			!= (void far *)0);
	}
	int  unlock();
	operator void far *()
	{
		if (!p) lock(); return p;
	}
	voidVFP& operator=(void far *p)
	{
		hseg = hofs = NULL;
		this->p = p;
		return *this;
	}
	int farmalloc(unsigned long nbytes)
	{
		p = (void far *) 0;
		return FHeap.farmalloc(nbytes,&hseg,&hofs);
	}
	int farcalloc(unsigned long nunits,
		unsigned long unitsz);
	int farrealloc(unsigned long nbytes)
	{
		return FHeap.farrealloc(nbytes,&hseg,&hofs);
	}
	void farfree()
	{
		p = (void far *) 0;
		FHeap.farfree(hseg,hofs);
		hseg = hofs = NULL;
	}
};



#else              // Non Windows Appplication


#include <alloc.h>

class voidVP {
protected:
	void *p;
public:
	voidVP() { p = (void *) 0; }
	unsigned locks() { return (p? 1 : 0); }
	int  lock()   { return (p != (void *) 0); }
	int  unlock() { return 0; }
	operator void *() { return p; }
	voidVP& operator=(void *p)
		{ this->p = p; return *this; }
	int malloc(size_t size)
	{
		return ((p = ::malloc(size)) != (void *) 0);
	}
	int calloc(size_t nobj, size_t size)
	{
		return ((p = ::calloc(nobj,size))
			!= (void *) 0);
	}
	int realloc(size_t size);
	void free()
		{ ::free(p); p = (void *) 0; }
};


class voidVFP {
protected:
	void far *p;
public:
	voidVFP() { p = (void far *) 0; }
	unsigned locks() { return (p? 1 : 0); }
	int  lock()   { return (p != (void far *) 0); }
	int  unlock() { return 0; }
	operator void far *() { return p; }
	voidVFP& operator=(void far *p)
		{ this->p = p; return *this; }
	int farmalloc(unsigned long nbytes)
	{
		return ((p = ::farmalloc(nbytes))
			!= (void far *) 0);
	}
	int farcalloc(unsigned long nunits,
		unsigned long unitsz)
	{
		return ((p = ::farcalloc(nunits,unitsz))
			!= (void *) 0);
	}
	int farrealloc(unsigned long nbytes);
	void farfree()
		{ ::farfree(p); p = (void far *) 0; }
};

#endif


#define typeVP(type)  \
class type ## VP : voidVP  {  \
public:  \
	type ## VP () : voidVP() {}  \
	voidVP::locks; \
	voidVP::lock;  \
	voidVP::unlock;  \
	operator type *()  \
	{  \
		return (type *)(void *)(*this);  \
	}  \
	type ## VP& operator=(type * p)  \
	{  \
		return (type ## VP&)  \
			voidVP::operator=((void *)p);  \
	}  \
	int malloc()  \
	{  \
		return voidVP::malloc(sizeof(type));  \
	}  \
	int calloc(size_t nobj)  \
	{  \
		return voidVP::calloc(nobj,sizeof(type));  \
	}  \
	voidVP::free;  \
};  \
class type ## VFP : voidVFP  {  \
public:  \
	type ## VFP() : voidVFP() {}  \
	voidVFP::locks;  \
	voidVFP::lock;  \
	voidVFP::unlock;  \
	operator type far *()  \
	{  \
		return (type far *)(void far *)(*this);  \
	}  \
	type ## VFP& operator=(type far * p)  \
	{  \
		return (type ## VFP&)voidVFP::  \
			operator=((void far *)p);  \
	}  \
	int farmalloc()  \
	{  \
		return voidVFP::  \
			farmalloc(sizeof(type));  \
	}  \
	int farcalloc(unsigned long nunits)  \
	{  \
		return voidVFP::  \
			farcalloc(nunits,sizeof(type));  \
	}  \
	voidVFP::farfree;  \
}



#endif
