Program TestVPD;

{$R-} {$S-} {$D-} {$L-} {$N-}

{ͻ
  Demo program for VPD256.BGI 
  and TURBO-PASCAL 5.0/5.5    
 Ķ
  COPYRIGHT(C) 1990 by H+BEDV 
 Ķ
                              
  Mode  Resolution  Scr. Pages
                              
   0     320*240        3     
   1     360*240        3     
   2     320*400        2     
   3     360*480        1     
                              
 ͼ}

Uses Crt,Graph;

Var GraphMode   : Integer;
    GraphDriver : Integer;
    X,C,K,L,M   : Integer;
    R,G,B       : Integer;
    PC          : Real;
    CPal        : Array[0..255,0..2] Of Byte;



{Ŀ
  The following function simply overrides the automatic detection of    
  GRAPH.TPU and is necessary to initialize VPD256.BGI. The function     
  AutoDetect MUST be declared as FAR! The function result of Autodetect 
  determines the graphic mode, and must be in the range [0..3].         
 }

{$F+}
Function AutoDetect : Integer;
Begin
 AutoDetect := 3;              {We will use mode 3 with 360*480 pixels}
End; {AutoDetect}
{$F-}



{Ŀ
  This procedure is used to define the 256 entries of the color palette  
  In the actual driver the setting of the DAC is easier, because you can 
  use the new predifined procedures SetAllRGBPalette and GetAllRGBPalette
 }

Procedure ComputeHue;
Begin
 For C := 0 To 255 Do
 Begin
  M :=(C*3) Shr 1;
  Case M Of
     0.. 63 : Begin CPal[C,0] := 63;CPal[C,1] := M;CPal[C,2] := 0; End;
    64..127 : Begin CPal[C,0] := 127-M;CPal[C,1] := 63;CPal[C,2] := 0; End;
   128..191 : Begin CPal[C,0] := 0;CPal[C,1] := 63;CPal[C,2] := M-128; End;
   192..255 : Begin CPal[C,0] := 0;CPal[C,1] := 255-M;CPal[C,2] := 63; End;
   256..319 : Begin CPal[C,0] := M-256;CPal[C,1] := 0;CPal[C,2] := 63; End;
   320..383 : Begin CPal[C,0] := 63;CPal[C,1] := 0;CPal[C,2] := 383-M; End;
  End;
 End;
 CPal[0,0] := 0;
 CPal[0,1] := 0;
 CPal[0,2] := 0;
 CPal[255,0] := 63;
 CPal[255,1] := 63;
 CPal[255,2] := 63;
 For C := 0 To 255 Do SetRGBPalette(C,CPal[C,0],CPal[C,1],CPal[C,2]);
End; {ComputeHue}



Begin {Main program}

{Ŀ
  First we install the BGI driver VPD256.BGI 
 }

 GraphDriver := InstallUserDriver('VPD256',@AutoDetect);

{Ŀ
  Then we set GraphDriver to DETECT and use our own AutoDetect 
 }

 GraphDriver := Detect;

{Ŀ
  Then we have to initialize the graphics 
 }

 InitGraph(GraphDriver,GraphMode,'');

{Ŀ
  Optionally we will define our own color palette 
 }

 ComputeHue;

{Ŀ
  Now we can use the driver in the same way as any other BGI driver,  
  but with up to 360*480 pixels in 256 colors simultaniously.         
 }

 SetColor(255);
 Rectangle(0,0,GetMaxX,GetMaxY);
 Line(0,0,GetMaxX,GetMaxY);
 Line(GetMaxX,0,0,GetMaxY);
 SetTextStyle(DefaultFont,Horizdir,2);
 SetTextJustify(CenterText,BottomText);
 OutTextXY(GetMaxX Div 2,20,'Welcome to VPD256');
 SetTextStyle(DefaultFont,Horizdir,1);
 OutTextXY(GetMaxX Div 2,36,'Mode: '+GetModeName(GetGraphMode));
 SetColor(50);
 OutTextXY(GetMaxX Div 2,55,'Now you should try');
 SetColor(100);
 OutTextXY(GetMaxX Div 2,65,'your own graphic');
 SetColor(150);
 OutTextXY(GetMaxX Div 2,75,'applications');
 SetColor(200);
 OutTextXY(GetMaxX Div 2,85,'with VPD256!');

 C := 1;
 For X := (GetMaxX Div 2)-127 To (GetMaxX Div 2)+126 Do
 Begin
  SetColor(C);
  Line(X,GetMaxY-5,X,GetMaxY-20);
  Inc(C);
 End;

 PC := 1;
 For X := 0 To 356 Do
 Begin
  C := Trunc(PC);
  SetColor(C);
  SetFillStyle(SolidFill,C);
  PieSlice(GetMaxX Div 2,11*GetMaxY Div 15,X,X+4,39);
  PC := PC+254/360;
 End;

 Repeat
  For K := 0 To 1 Do
  Begin
   R := CPal[254,0];
   G := CPal[254,1];
   B := CPal[254,2];
   For L := 254 DownTo 1 Do CPal[L] := CPal[L-1];
   CPal[1,0] := R;
   CPal[1,1] := G;
   CPal[1,2] := B;
  End;
  For C := 0 To 255 Do SetRGBPalette(C,CPal[C,0],CPal[C,1],CPal[C,2]);
 Until Keypressed;

 CloseGraph;
 TextMode(LastMode);

End. {Main program}
