/*ͻ
   Demo Source Code for VPD256.BGI 
  Ķ
   Version: TURBO-C 2.0, Turbo-C++ 
  Ķ
   COPYRIGHT(C) 1990 by H+BEDV     
  Ķ
                                   
    Mode  Resolution  Screen Pages 
                                   
     0     320*240         3       
     1     360*240         3       
     2     320*400         2       
     3     360*480         1       
                                   
  ͼ*/

#ifdef __TINY__
#error BGIDEMO will not run in the tiny model.
#endif

#include <stdio.h>
#include <conio.h>
#include <graphics.h>

typedef char T_CPAL[256][3];

int graphmode;
int graphdriver;
int x,c,k,l,m;
int r,g,b;
float pc;
T_CPAL cpal;


/*Ŀ
   The following function simply overrides the automatic driver detection 
   of TURBO-C and is necessary to initialize VPD256.BGI. The function     
   autodetect MUST be declared as HUGE! The function result of autodetect 
   determines the graphic mode, and must be in the range [0..3].          
  */


int huge autodetect(void)
{
  int r_autodetect;

  r_autodetect=3;       /* We will use mode 3 with 360*480 pixels */
  return r_autodetect;

} /* End of AutoDetect */



/*Ŀ
   This function is used to define the 256 entries of the color palette   
   In the actual driver the setting of the DAC is easier, because you can 
   use the new predifined functions setallrgbpalette and getallrgbpalette 
  */

void computehue(void)
{
  for (c=0;c<=255;c++) {
    m= (c*3)>>1;
    if ((m<64)) {
      cpal[c][0]=63;
      cpal[c][1]=m;
      cpal[c][2]=0;
    }
    if ((m>63) && (m<128)) {
      cpal[c][0]=127-m;
      cpal[c][1]=63;
      cpal[c][2]=0;
    }
    if ((m>127) && (m<192)) {
      cpal[c][0]=0;
      cpal[c][1]=63;
      cpal[c][2]=m-128;
    }
    if ((m>191) && (m<256)) {
      cpal[c][0]=0;
      cpal[c][1]=255-m;
      cpal[c][2]=63;
    }
    if ((m>255) && (m<320)) {
      cpal[c][0]=m-256;
      cpal[c][1]=0;
      cpal[c][2]=63;
    }
    if ((m>319)) {
      cpal[c][0]=63;
      cpal[c][1]=0;
      cpal[c][2]=383-m;
    }
  }
  cpal[0][0]=0;
  cpal[0][1]=0;
  cpal[0][2]=0;
  cpal[255][0]=63;
  cpal[255][1]=63;
  cpal[255][2]=63;
  for (c=0;c<=255;c++) setrgbpalette(c,cpal[c][0],cpal[c][1],cpal[c][2]);

} /* End of ComputeHue */



/* Main program starts here */

int main(void)
{

 /*Ŀ
    First we install the BGI driver VPD256.BGI 
   */

  graphdriver=installuserdriver("VPD256",*autodetect);

 /*Ŀ
    Then we set GraphDriver to DETECT and use our own autodetect 
   */

  graphdriver=DETECT;

 /*Ŀ
    Then we have to initialize the graphics 
   */

  initgraph(&graphdriver,&graphmode,"");

 /*Ŀ
    Optionally we will define our own color palette 
   */

  computehue();

 /*Ŀ
    Now we can use the driver in the same way as any other BGI driver,  
    but with up to 360*480 pixels in 256 colors simultaniously.         
   */

  setcolor(255);
  rectangle(0,0,getmaxx(),getmaxy());
  line(0,0,getmaxx(),getmaxy());
  line(getmaxx(),0,0,getmaxy());
  settextstyle(DEFAULT_FONT,HORIZ_DIR,2);
  settextjustify(CENTER_TEXT,BOTTOM_TEXT);
  outtextxy(getmaxx()/2,20,"Welcome to VPD256");
  settextstyle(DEFAULT_FONT,HORIZ_DIR,1);
  outtextxy(getmaxx()/2,36,getmodename(getgraphmode()));
  setcolor(50);
  outtextxy(getmaxx()/2,55,"Now you should try");
  setcolor(100);
  outtextxy(getmaxx()/2,65,"your own graphic");
  setcolor(150);
  outtextxy(getmaxx()/2,75,"applications");
  setcolor(200);
  outtextxy(getmaxx()/2,85,"with VPD256!");

  c=1;
  for (x=(getmaxx()/2)-127;x<=(getmaxx()/2)+126;x++) {
    setcolor(c);
    line(x,getmaxy()-5,x,getmaxy()-20);
    (c)++;
  }

  pc=1.0;
  for (x=0;x<=356;x++) {
    setcolor(pc);
    setfillstyle(SOLID_FILL,pc);
    pieslice(getmaxx()/2,11*getmaxy()/15,x,x+4,39);
    pc=pc+254.0/360.0;
  }

  do {
    for (k=0;k<=1;k++) {
      r=cpal[254][0];
      g=cpal[254][1];
      b=cpal[254][2];
      for (l=254;l>=1;l--) {
	cpal[l][0]=cpal[l-1][0];
	cpal[l][1]=cpal[l-1][1];
	cpal[l][2]=cpal[l-1][2];
      }
      cpal[1][0]=r;
      cpal[1][1]=g;
      cpal[1][2]=b;
    }
    for (c=0;c<=255;c++) setrgbpalette(c,cpal[c][0],cpal[c][1],cpal[c][2]);
  } while (!(kbhit()));

  closegraph();
  textmode(C80);
  return 0;

} /* End of main program */
