// CHGVOL - Change Volume Label program
// Copyright 1991 - By Tom Astin - 73407,3427
// Use as is. Not responisble for performance
// Demonstrates use of VOLLAB.CPP (class VolLabel)
// See VOLLAB.H for brief documentation
// Minimal testing done.

#include <iostream.h>
#include <stdlib.h>
#include <ctype.h>
#include "vollab.h"

void ErrorMsg(char *msg)
{
	cout << msg << endl << endl;
	exit(1);
}

int main(int argc,char *argv[])
{
	char NewLabel[12];
	VolLabel vl;
	unsigned char nDrive=0;
	char cDrive;
	char *szLabel, ch;

	cout << "Volume label changer." << endl << endl;

	if (argc>2)
		ErrorMsg("Invalid number of parameters.");

	if (argc==2) {
		cDrive=toupper(argv[1][0]);
		if (strlen(argv[1])>2 || argv[1][1]!=':' || cDrive<'A' || cDrive>'Z')
			ErrorMsg("Invalid parameter.");
		nDrive='A'-cDrive+1;
	}
	else {
		nDrive=vl.GetDisk();
		cDrive='A'+nDrive;
		++nDrive;
	}


	if (!(szLabel=vl.GetLabel(nDrive)) && vl.IsError())
		ErrorMsg("Error getting label.");

	cout << "The current label for drive " << cDrive << ": is "
		 << (char *) (szLabel!=0 ? szLabel : "none") << endl << endl;

	cout << "Enter new label (11 chars max): ";
	cin.get(NewLabel,12);
	cin.ignore();

	if (strlen(NewLabel)) {
		if (!vl.SetLabel(nDrive,NewLabel))
			ErrorMsg("Error while changing label.");
	}
	else {
		cout << "Remove volume label (Y/N)?";
		cin.get(ch);
		if (toupper(ch)=='Y') {
			if (!vl.Remove(nDrive))
				ErrorMsg("Error removing volume label.");
			else
				cout << "Volume label removed." << endl;
		}
		else
			cout << "Volume label not changed." << endl;
	}
	return 0;
}