/* Volume Label Class
   By Tom Astin 73407,3427
   Copyright 1991

   Below is a quick hack to Get, Set, and Remove the volume label from a
   DOS disk.  It has not been tested more than once on a floppy disk so
   use at your own risk.

   Dos will return AL=0xFF on most of these fcb functions that fail.
   AL=0xFF doesn't neccessarily mean a major general failure.
	  (ie: Dos label isn't there).
   IsError() will return non-zero if an abonormal dos error occurs.
   Does not trap fatal errors. (int 24)
   *** All drive parameters are as follows: 0=Current, 1=A, 2=B, etc.
   *** Caller is not responsible for any heap deallocation except for
	   object instance (ie: returned char* are not on heap).
   *** Regarding serial numbers: Large media is now supported but not
	   extensively tested.  USE AT YOUR OWN RISK.  This class was tested on
	   a 1.2mb floppy and a 130mb hard drive (only one time on
	   the hard drive).
*/

#include <dos.h>
#include <string.h>

class VolLabel {
	xfcb	xf,*pxf;    // xf is general xfcb, pxf will point to buf.
	char	*buf[64];   // temp dta

	struct { 			// special FCB
		char flg;
		char r1[5];
		char attr;
		char dr;
		char oldn[11];
		char r2[5];
		char newn[11];
		char r3[9];
	} fcbSpec;

	typedef struct {
		unsigned long nSector;
		unsigned short nToRead;
		void far *pBuffer;
	} strParmBlock;
	typedef strParmBlock far *pstrParmBlock;

	void SetupXFCB();	// fill in default fields of xf
	int bDosErr;		// boolean Dos Error?
	unsigned int res;   // last AX return from dos fcb functions
	void CustomDos(unsigned char ah, void far *data); // our dos caller
	unsigned short SectorSize(int nDrive); // return physical sector size
public:
	char *GetLabel(int nDrive);
	  // return char * to the current label for specified drive
	  // return NULL if no label present
	int SetLabel(int nDrive, char *szLabel);
	  // change the current label for the specified drive
	  // return non-zero on success
	int Remove(int nDrive);
	  // remove the current label so there will be none.
	  // return non-zero on success
	inline int IsError() {return bDosErr;}
	  // return non-zero on major dos error
	inline unsigned ErrorCode() {return res;}
	  // return AX value returned from function
	unsigned long GetSerial(unsigned char nDrive);
	  // return unsigned long serial number from boot record
	int SetSerial(unsigned char nDrive, unsigned long nSerial);
	  // set the serial # by modifying disk boot record
	unsigned char GetDisk();
	  // return current disk number A=0, B=1, etc.
	float MediaSize(unsigned char nDrive);
	  // get media size (in mega bytes or fraction thereof)
	  // of nDrive.  0=Current, A=1, B=2, etc.
	int myabsread(int drive, int nsects, long lsect, void far *buffer);
	  // special absread - detects media size and uses appropriate call
	int myabswrite(int drive, int nsects, long lsect, void far *buffer);
	  // special abswrite - detects media size and uses appropriate call
};
