#include "memory.h"

#if !defined( __ALLOC_H )
#include <alloc.h>
#endif

long ConvMemPoolSize = 0;

ConvMemory::ConvMemory()
	{
	vp = 0;
	}

ConvMemory::ConvMemory( size_t sz )
	{
	vp = 0;
	allocate(sz);
	}

ConvMemory::~ConvMemory()
	{
	free();
	}

int ConvMemory::allocate( size_t sz )
	{
	if( vp != 0 || sz == 0 )	return 0;
	long l = maxAvail();
	if( l-(long)sz < ConvMemPoolSize )
		return 0;
	vp = new char [sz];
	if( vp != 0 )
		memsize = sz;
	else
		memsize = 0;
	return (vp == 0) ? 0 : sz;
	}

void ConvMemory::free()
	{
	if( lockflag )
		return;
	delete vp;
	vp = 0;
	}

void far *ConvMemory::lock()
	{
	if( vp )
		lockflag++;
	return vp;
	}

void ConvMemory::unlock()
	{
	if( lockflag )
		lockflag--;
	}

long ConvMemory::memAvail()
	{
	long l = coreleft();
	struct heapinfo heap;

	switch( heapcheck() )
		{
		case _HEAPEMPTY:
			break;

		case _HEAPCORRUPT:
			l = 0;
			break;

		case _HEAPOK:
			heap.ptr = NULL;
			while(heapwalk(&heap) != _HEAPEND)
				if(!heap.in_use)
					l += heap.size;
			break;
		}
	return l;
	}

long ConvMemory::maxAvail()
	{
	long l = coreleft();
	struct heapinfo heap;

	switch( heapcheck() )
		{
		case _HEAPEMPTY:
			break;

		case _HEAPCORRUPT:
			l = 0;
			break;

		case _HEAPOK:
			heap.ptr = NULL;
			while(heapwalk(&heap) != _HEAPEND)
				if( !heap.in_use && heap.size > l )
					l = heap.size;
			break;
		}
	return l;
	}
