#include "vmemmgr.h"

VMemItem::~VMemItem()
	{
	clear();
	}

void VMemItem::clear()
	{
	buffer = 0;
	lockflag = 0;
	flags = 0;
	}


VMemBlocks::VMemBlocks( int aLimit, unsigned aMemSize ) :
items(0),
fp(0),
limit(aLimit),
memSize(aMemSize),
defaultBuffer(0)
	{
	items = new VMemItem [limit];
	if( items != 0 )
		{
		defaultBuffer = (void *) new char [memSize];
		if( defaultBuffer == 0 )
			{
			delete items;
			items = 0;
			}
		else
			{
			fp = tmpfile();
			if( fp == NULL )
				{
				delete defaultBuffer;	defaultBuffer = 0;
				delete items;			items = 0;
				}
			else
				{
				fseek( fp, (long)memSize*(long)limit, SEEK_SET );
				fputc( 0, fp );
				if( ftell(fp) < (long)memSize*(long)limit )
					{
					fclose(fp);				fp = 0;
					delete defaultBuffer;	defaultBuffer = 0;
					delete items;			items = 0;
					}
				}
			}
		}
	}

VMemBlocks::~VMemBlocks()
	{
	clear();
	delete items;			items = 0;
	delete defaultBuffer;   defaultBuffer = 0;
	limit = 0;
	}

int VMemBlocks::valid()
	{
	if( items == 0 )
		return 0;
	return 1;
	}

void VMemBlocks::clear()
	{
	int i;

	if( valid() )
		for( i = 0; i < limit; i++ )
			{
			if( (items[i].flags & vmInMemory) != 0 )
				if( items[i].buffer != defaultBuffer )
					delete items[i].buffer;
			items[i].clear();
			}
	}

int VMemBlocks::allocate()
	{
	int index;

	if( !valid() )	return -1;
	for( index = 0; index < limit; index++ )
		if( (items[index].flags & vmInUse) == 0 )
			{
			items[index].flags |= vmInUse;
			return index;
			}
	return -1;
	}

void *VMemBlocks::lock( int handle )
	{
	if( !valid() || handle < 0 || handle >= limit ||
			(items[handle].flags & vmInUse) == 0 )
		return 0;

	if( (items[handle].flags & vmInMemory) == 0 )
		{
		items[handle].buffer = (void *) new char [memSize];
		if( items[handle].buffer == 0 )
			items[handle].buffer = getBuffer();

		if( (items[handle].flags & vmOnDisk) != 0 )
			readFromFile( handle );
		}

	if( items[handle].buffer != 0 )
		{
		items[handle].flags |= vmInMemory;
		items[handle].lockflag++;
		}
	return items[handle].buffer;
	}

void VMemBlocks::unlock( int handle )
	{
	if( valid() && handle >= 0 && handle < limit &&
			(items[handle].flags & vmInUse) != 0 &&
			items[handle].lockflag )
		items[handle].lockflag--;
	}

void VMemBlocks::free( int handle )
	{
	if( !valid() || handle < 0 || handle >= limit ||
		(items[handle].flags & vmInUse) == 0 ||
		items[handle].lockflag )
		return;

	if( (items[handle].flags & vmInMemory) != 0 )
		{
		if( items[handle].buffer != defaultBuffer )
			delete items[handle].buffer;
		items[handle].buffer = 0;
		items[handle].flags &= ~vmInMemory;
		}
	items[handle].flags = 0;
	}

void *VMemBlocks::getBuffer()
	{
	int index;

	if( !valid() )	return 0;

	for( index = 0; index < limit; index++ )
		if( items[index].buffer == defaultBuffer )
			break;
	if( index >= limit )
		return defaultBuffer;
	if( items[index].lockflag != 0 )
		for( index = 0; index < limit; index++ )
			if( (items[index].flags & vmInMemory) != 0 &&
					items[index].lockflag == 0 )
				break;

	if( items[index].lockflag || (items[index].flags & vmInMemory) == 0 )
		return 0;

	fseek(fp, (long)index*(long)memSize, SEEK_SET );
	fwrite( items[index].buffer, 1, memSize, fp );
	items[index].flags |= vmOnDisk;
	items[index].flags &= ~vmInMemory;
	void *p = items[index].buffer;
	items[index].buffer = 0;
	return p;
	}

void VMemBlocks::readFromFile( int index )
	{
	if( index < 0 || index >= limit || (items[index].flags & vmInUse) == 0 ||
			(items[index].flags & vmOnDisk) == 0 || items[index].lockflag ||
			items[index].buffer == 0 )
		return;

	fseek(fp, (long)index*(long)memSize, SEEK_SET );
	fread( items[index].buffer, 1, memSize, fp );
	items[index].flags &= ~vmOnDisk;
	items[index].flags |= vmInMemory;
	}

