#include "memory.h"
#include <iostream.h>
#include <string.h>

MemoryObject *memory[80];
char *teststr = "string 00";

extern long ConvMemPoolSize;

int main()
	{
	void far *ptr;
	int i, failcnt, faillock, count, convtype, emstype, disktype;
	ConvMemory mem;

	// Make sure disk type has a buffer available.

	ConvMemPoolSize = 15000;

	cout << "Going for 800,000 alloc." << endl;
	convtype = emstype = disktype = 0;
	for( count = 0; count < 80; count++ )
		{
		memory[count] = VMemManager::allocate(10000);
		if( memory[count] == 0 )
			break;
		if( memory[count]->type() == MemConventional )
			convtype++;
		else if( memory[count]->type() == MemEMS )
			emstype++;
		else
			disktype++;
		}

	cout << "Allocated " << count << " total. Types:" << endl;
	cout << "    " << convtype << " conventional." << endl;
	cout << "    " << emstype  << " EMS." << endl;
	cout << "    " << disktype << " disk." << endl;


	// Use conventional pool for disk frame.

	ConvMemPoolSize = 0;

	failcnt = 0;
	for( i = 0; i < count; i++ )
		{
		teststr[8]++;
		if( teststr[8] > '9' )
			{
			teststr[8] = '0';
			teststr[7]++;
			}
		ptr = memory[i]->lock();
		if( ptr == 0 )
			failcnt++;
		else
			_fstrcpy( (char far *)ptr, teststr );
		memory[i]->unlock();
		}
	if( failcnt )
		cout << "Failed locking " << failcnt << " items." << endl;
	else
		{
		teststr[7] = teststr[8] = '0';
		failcnt = faillock = 0;
		for( i = 0; i < count; i++ )
			{
			teststr[8]++;
			if( teststr[8] > '9' )
				{
				teststr[8] = '0';
				teststr[7]++;
				}
			ptr = memory[i]->lock();
			if( ptr == 0 )
				faillock++;
			else
				if( _fstrcmp( (char far *)ptr, teststr ) != 0 )
					failcnt++;
			memory[i]->unlock();
			}

		if( failcnt )
			cout << "Failed testing " << failcnt << " items." << endl;
		if( faillock )
			cout << "Failed locking " << faillock << " items." << endl;

		if( !failcnt && !faillock )
			cout << "Everybody passes!" << endl;
		}

	for( i = 0; i < count; i++ )
		{
		memory[i]->free();
		delete memory[i];
		memory[i] = 0;
		}
	return 0;
	}
