#if !defined __VMEMMGR_H
#define __VMEMMGR_H

#if !defined __STDIO_H
#include <stdio.h>
#endif

const unsigned	vmInMemory =	0x0001,
				vmOnDisk =		0x0002,
				vmInUse =		0x0004;

class VMemItem
	{
	friend class VMemBlocks;

	void *buffer;
	int lockflag;
	unsigned flags;

	public:

		VMemItem() :
			buffer(0),
			lockflag(0),
			flags(0)
			{}
		~VMemItem();

		void clear();
	};

class VMemBlocks
	{
	public:

		VMemBlocks( int aLimit, unsigned aMemSize );
		~VMemBlocks();

		virtual int valid();
		virtual void clear();

		int allocate();
		void *lock( int handle );
		void unlock( int handle );
		void free( int handle );

	protected:

		VMemItem *items;
		int limit;
		unsigned memSize;
		void *defaultBuffer;
		FILE *fp;

		void *getBuffer();
		void readFromFile( int index );
	};

#endif	// __VMEMMGR_H
