//. MODULE: DBCollection source

// @@DatatypeInclude
#ifndef INC_GLOBAL_HPP
#include "global.hpp"
#endif
// @@End
// @@Includes
#ifndef INC_DBCOLLEC_HPP
#include "dbcollec.hpp"
#endif
#ifndef INC_VIRRECID_HPP
#include "virrecid.hpp"
#endif
// @@End
#ifndef INC_REFCOUNT_HPP
#include "refcount.hpp"
#endif
void DBAbstractCollection::SetCount ()
{
	count = pElement->GetCount ( node ) ;
}

VirtualRecordId DBAbstractCollection::At (unsigned long num)
{
	VirtualRecordId id ;	//	must be zeroed !
	if ( Valid () )
	{
		Goto( num ) ;
		id = pElement->GetVirtualRecordId () ;
	}
	return id ;
}

DBAbstractCollection::DBAbstractCollection (unsigned long id, DBElementBase* anElement, unsigned short len)

 : node ( id ), pElement (anElement),
count(0),
current(0),
initHasBeenCalled(False),
cColWidth(len),
// @@OEW generated
CollectionId(CollectionCount++)
{
	node.New () ; // on disk
	ref = new RefCounter ();
}

void DBAbstractCollection::Insert (const VirtualRecordId& rec_ids, const char* str, const char* key)
{
	pElement->SetVirtualRecordId ( rec_ids ) ;
	pElement->SetString ( str ) ;
	pElement->SetSequence ( current++ );
	if ( IsSorted () )
	{
		WARN ( key == 0, "NULL key on Insert call to a DBSortedCollection" );
		pElement->SetKey ( key );
	}
	pElement->New ( node ) ;
}

VirtualRecordId DBAbstractCollection::GetVirtualRecordId () const 
{
	VirtualRecordId id ;	//	must be zeroed !
	if ( Valid () )
	{
		id = pElement->GetVirtualRecordId () ;
	}
	return id ;
}

void DBAbstractCollection::First ()
{
	current = 0 ;pElement->First ( node );
}

void DBAbstractCollection::Next ()
{
	pElement->Next () ;
	if ( pElement->Okay () )
	{
		current++ ;
	}
	else
	{
		pElement->SetStatus ( S_OKAY ) ;
		Last () ;
	}
}

void DBAbstractCollection::Prev ()
{
	pElement->Prev () ;
	if ( pElement->Okay () )
	{
		current-- ;
	}
	else
	{
		First () ;
	}
}

void DBAbstractCollection::Last ()
{
	current = count - 1 ; pElement->Last () ;
}

BOOL DBAbstractCollection::Okay () const 
{
	return BOOL ( node.Okay () && pElement->Okay () );
}

void DBAbstractCollection::Init ()
{
	First () ;
	SetCount () ;
	initHasBeenCalled = TRUE ;
}

DBAbstractCollection & DBAbstractCollection::Goto (unsigned long num)
{
	if ( ! Valid () )
	{
		return *this ;
	}
	if ( ! Okay () )
	{
		First () ;
	}
	CHECK ( Okay () );
	if ( num < current )
	{
		while ( num < current )
		{
			Prev () ;
		}
	}
	else if ( num < count )
	{
		while ( num > current )
		{
			Next () ;
		}
	}
	else if ( num >= count )
	{
		Last () ;
	}
	CHECK ( Okay () );
	return *this ;
}

BOOL DBAbstractCollection::Valid () const 
{
	return BOOL 
	( 
		initHasBeenCalled &&
		count > 0L
	) ;
}

DBAbstractCollection::~DBAbstractCollection ()
{
	if ( ref && --ref->count == 0 )
	{
		DestroyCollection () ;
	}
	delete pElement ; pElement = 0;
}

DBSortedCollection::DBSortedCollection (unsigned long id, unsigned short len)

 : DBAbstractCollection ( id, SuitableElement (len), len )
{
	
}

DBElementBase * DBSortedCollection::SuitableElement (unsigned short len)
{
	if ( len < DBElementBase::SmallElementWidth )
	{
		return new DBSortedSmallCollectionElement ;
	}
	else if ( len < DBElementBase::LargeElementWidth )
	{
		return new DBSortedLargeCollectionElement ;
	}
	else
	{
		CHECK ( "Element width too large for current DBElements" ) ;
		return 0;
	}
}

DBUnsortedCollection::DBUnsortedCollection (unsigned long id, unsigned short len)

 : DBAbstractCollection ( id, SuitableElement (len), len )
{
	
}

DBElementBase * DBUnsortedCollection::SuitableElement (unsigned short len)
{
	if ( len < DBElementBase::SmallElementWidth )
	{
		return new DBSmallCollectionElement ;
	}
	else if ( len < DBElementBase::LargeElementWidth )
	{
		return new DBLargeCollectionElement ;
	}
	else
	{
		CHECK ( "Element width too large for current DBElements" ) ;
		return 0;
	}
}

long DBAbstractCollection::GotoVirtualRecordId (VirtualRecordId& id)
{
	if ( Valid () )
	{
		long cNew = pElement->GotoVirtualRecordId ( id ) ;
		if ( cNew > -1L )
		{
			current = cNew ;
			return current ;
		}
		else
		{
			throw xmsg ( "Can't go to virtual record id" ) ;
		}
	}
	else
		return -1 ;
}

VirtualRecordId::VirtualRecordId (const DB_ADDR adr[])

{
	for ( int i=0; i < DBElementBase::RecCount ; i++ )
	{
		recordAddresses[i] = adr[i] ;
	}
}

VirtualRecordId::VirtualRecordId (const VirtualRecordId& otro)

{
	for ( int i=0; i < DBElementBase::RecCount ; i++ )
	{
		recordAddresses[i] = otro.recordAddresses[i] ;
	}
}

void VirtualRecordId::CopyTo (DB_ADDR dba[], unsigned count) const 
{
	unsigned n = min ( count, static_cast<unsigned>(DBElementBase::RecCount) ) ;
	for ( int i=0; i < n ; i++ )
	{
		dba[i] = recordAddresses[i] ;
	}
}

VirtualRecordId::VirtualRecordId ()

{
	for ( int i=0; i < DBElementBase::RecCount ; i++ )
	{
		recordAddresses[i] = 0L ;
	}
}

VirtualRecordId & VirtualRecordId::operator = (const VirtualRecordId& otro)
{
	for ( int i=0; i < DBElementBase::RecCount ; i++ )
	{
		recordAddresses[i] = otro.recordAddresses[i] ;
	}
	return *this ;
}

const DB_ADDR & VirtualRecordId::operator [] (unsigned x) const //; in liew of exception handling !
{
	PRECONDITION ( x < DBElementBase::RecCount ) ;
	return recordAddresses[x];
}

DB_ADDR & VirtualRecordId::operator [] (unsigned x)//; in liew of exception handling !
{
	PRECONDITION ( x < DBElementBase::RecCount ) ;
	return recordAddresses[x];
}

VirtualRecordId::VirtualRecordId (const DB_ADDR firstDba)

{
	for ( int i=0; i < DBElementBase::RecCount ; i++ )
	{
		recordAddresses[i] = 0L ;
	}
	recordAddresses[0] = firstDba ;
}

long DBAbstractCollection::CollectionCount = 0;
void DBAbstractCollection::DestroyCollection ()
{
	PRECONDITION ( pElement != 0 );
	
	// first delete collection elements ...
	for ( pElement->First (node) ; pElement->Okay (); pElement->First (node) )
	{
		pElement->Destroy ( node ) ;
	}
	node.Delete () ;
	
	delete ref ; ref = 0;
}

DBAbstractCollection & DBAbstractCollection::operator = (const DBAbstractCollection& o)
{
	if ( this != &o )
	{
		if ( --ref->count == 0 )
			DestroyCollection ();
		CollectionId = o.CollectionId ;
		cColWidth = o.cColWidth ;
		count = o.count ;
		current = o.current ;
		initHasBeenCalled = o.initHasBeenCalled ;
		node = o.node ;
		ref = o.ref ;
		ref->count++ ;
		delete pElement ;
		pElement = o.pElement->CloneElement () ;
	}
	return *this;
}

DBAbstractCollection::DBAbstractCollection (const DBAbstractCollection& o)

 : // @@OEW generated
pElement(0),
cColWidth(0),
CollectionId(CollectionCount++)
{
	CollectionId = o.CollectionId ;
	cColWidth = o.cColWidth ;
	count = o.count ;
	current = o.current ;
	initHasBeenCalled = o.initHasBeenCalled ;
	node = o.node ;
	ref = o.ref ;
	ref->count++ ;
	pElement = o.pElement->CloneElement () ;
}

DBSortedCollection::DBSortedCollection (const DBSortedCollection& o)

 : DBAbstractCollection ( o )
{
	
}

DBAbstractCollection * DBSortedCollection::Clone ()
{
	return new DBSortedCollection (*this) ;
}

DBUnsortedCollection::DBUnsortedCollection (const DBUnsortedCollection& o)

 : DBAbstractCollection ( o )
{
	
}

DBAbstractCollection * DBUnsortedCollection::Clone ()
{
	return new DBUnsortedCollection (*this) ;
}

