//. MODULE: TVListBox source

// @@DatatypeInclude
#ifndef INC_GLOBAL_HPP
#include "global.hpp"
#endif
// @@End
// @@Includes
#ifndef INC_TVLISTBO_HPP
#include "tvlistbo.hpp"
#endif
#ifndef INC_VLISTDLL_HPP
#include "vlistdll.hpp"
#endif
// @@End
#ifndef INC_DBCOLLEC_HPP
#include "dbcollec.hpp"
#endif
TVListBox::TVListBox (TWindow* parent, int id, int x, int y, int w, int h, TModule* module)

 : TControl(parent, id, 0, x, y, w, h, module),
pVLBox(0),
items(0)
{
	// Attr.Style |= LBS_STANDARD; // ?
}

TVListBox::TVListBox (TWindow* parent, int resourceId, TModule* module)

 : TControl(parent, resourceId, module),
pVLBox(0),
items(0)
{
	
}

TVListBox::TVListBox (const TVListBox& rTvListBox)

 : TControl ( rTvListBox.Parent, rTvListBox.Attr.Id, rTvListBox.GetModule() ),
pVLBox(0),
items(0)
{
	
}

void TVListBox::ClearList ()//: Returns the number of entries in the associated listbox, a negative
	//. value if an error occurs
{
	HandleMessage(VLB_RESETCONTENT);
}

long TVListBox::FindString (const char far* find, long indexStart) const //: Retrieves the contents of the string at the passed index of the
	//+ associated listbox. Returns the length of the string (in bytes
	//+ excluding the terminating 0),  a negative if the passed index is not valid
	//+ 
	//. The buffer must be large enough for the string and the terminating 0
{
	VLBSTRUCT  vlbOutStruct;
	vlbOutStruct.lData = vlbOutStruct.lIndex = indexStart ;
	vlbOutStruct.lpFindString = CONST_CAST(char far*,find) ;
	
	return (long)CONST_CAST(TVListBox*,this)->
			 HandleMessage(VLB_FINDSTRING, 0, (LPARAM)(LPVLBSTRUCT)&vlbOutStruct );
}

long TVListBox::VlbGetCount () const //: Couldn't it return unsigned long
	//. instead ?
{
	return (long)CONST_CAST(TVListBox*,this)->HandleMessage(VLB_GETCOUNT);
}

int TVListBox::GetHorizontalExtent () const 
{
	return (int)CONST_CAST(TVListBox*,this)->HandleMessage(VLB_GETHORIZONTALEXTENT);
}

DWORD TVListBox::GetItemData (long index) const 
{
	VLBSTRUCT  vlbOutStruct;
	vlbOutStruct.lData = vlbOutStruct.lIndex = index ;
	
	return CONST_CAST(TVListBox*,this)->
		HandleMessage(VLB_GETITEMDATA, 0, (LPARAM)(LPVLBSTRUCT)&vlbOutStruct );
}

int TVListBox::GetItemHeight () const 
{
	return (int)CONST_CAST(TVListBox*,this)->
	         HandleMessage(VLB_GETITEMHEIGHT);
}

int TVListBox::GetItemRect (long index, TRect& rect) const 
{
	VLBSTRUCT  vlbOutStruct;
	vlbOutStruct.lData = vlbOutStruct.lIndex = index ;
	vlbOutStruct.lpTextPointer = (LPSTR)&rect ;
	return (int)CONST_CAST(TVListBox*,this)->
			 HandleMessage(VLB_GETITEMRECT, 0, (LPARAM)(LPVLBSTRUCT)&vlbOutStruct);
}

long TVListBox::GetSelIndex () const //: fills indexes with the indexes of up to maxCount selected strings
	//+ 
	//+ returns number of items put in the array(-1 for single-selection
	//. list boxes)
{
	return (long)CONST_CAST(TVListBox*,this)->HandleMessage(VLB_GETCURSEL);
}

int TVListBox::GetSelString (char far* str, int maxChars) const //: returns the number of selected items in the list box. For
	//. multiple-selection list boxes only
{
	long  index = GetSelIndex();
	
	if (index > -1) {
	  int  length = GetStringLen(index);
	
	  if (maxChars > length)
	    return GetString(str, index);
	
	  else {
	    char*  tmpStr = new char[length + 1];
	
	    if (tmpStr) {
	      GetString(tmpStr, index);
	      strncpy(str, tmpStr, maxChars);
	      delete tmpStr;
		  str[maxChars-1] = 0 ;
	      return maxChars-1;
	    }
	  }
	}
	return -1;
}

int TVListBox::GetString (char far* str, long index) const //: Returns the length of the string at the passed index in the associated
	//. listbox excluding the terminating 0, a negative if an error occurs
{
	VLBSTRUCT  vlbOutStruct;
	vlbOutStruct.lData = vlbOutStruct.lIndex = index ;
	vlbOutStruct.lpTextPointer = str ;
	return (int)CONST_CAST(TVListBox*,this)->
		HandleMessage(VLB_GETTEXT, 0, (LPARAM)(LPVLBSTRUCT)&vlbOutStruct );
}

void TVListBox::SetupWindow ()
{
	TControl::SetupWindow () ;
	pVLBox = (PVLBOX) GetWindowWord(0);
}

int TVListBox::GetStringLen (long index) const 
{
	VLBSTRUCT  vlbOutStruct;
	vlbOutStruct.lData = vlbOutStruct.lIndex = index ;
	
	return (int)CONST_CAST(TVListBox*,this)->
		HandleMessage(VLB_GETTEXTLEN, 0, (LPARAM)(LPVLBSTRUCT)&vlbOutStruct );
}

long TVListBox::GetTopIndex () const 
{
	return (long)CONST_CAST(TVListBox*,this)->HandleMessage(VLB_GETTOPINDEX);
}

TVListBox & TVListBox::operator = (const TVListBox&)
{
	return *this ;
}

void TVListBox::SetHorizontalExtent (int horzExtent)
{
	HandleMessage(VLB_SETHORIZONTALEXTENT, horzExtent);
}

int TVListBox::SetItemData (long index, DWORD itemData)
{
	VLBSTRUCT  vlbOutStruct;
	vlbOutStruct.lIndex = index ;
	vlbOutStruct.lData  = itemData ;
	return (int)HandleMessage(VLB_SETITEMDATA, 0, (LPARAM)(LPVLBSTRUCT)&vlbOutStruct );
}

int TVListBox::SetItemHeight (int height)
{
	return (int)HandleMessage(VLB_SETITEMHEIGHT, 0, MAKELPARAM(height,0) );
}

int TVListBox::SetSelIndex (int setOption, long index)
{
	return (int)HandleMessage(VLB_SETCURSEL, setOption, index );
}

long TVListBox::SetSelString (const char far* find, long indexStart)//: selects the strings in the associated list box which begin with
	//+ the passed prefixes
	//+ 
	//+ for each string the search begins at the beginning of the list
	//+ and continues until a match is found or until the list has been
	//+ completely traversed
	//+ 
	//+ if ShouldSet is TRUE, the matched strings are selected and highlighted;
	//+ otherwise the highlight is removed from the matched strings and they
	//+ are no longer selected
	//+ 
	//+ returns the number of strings successfully selected or deselected
	//+ 
	//+ if NumSelections is less than zero, all strings are selected or deselected
	//+ and a negative value is returned on failure
	//+ 
	//+ only for multiple-selection list boxes (-1 is returned if this is not
	//. a multiple-selection list box)
{
	VLBSTRUCT  vlbOutStruct;
	vlbOutStruct.lData = vlbOutStruct.lIndex = indexStart ;
	vlbOutStruct.lpFindString = CONST_CAST(char far*, find ) ;
	
	return (long)HandleMessage(VLB_SELECTSTRING, 0, 
				(LPARAM)(LPVLBSTRUCT)&vlbOutStruct );
}

BOOL TVListBox::SetTabStops (int numTabs, int far* tabs)
{
	return (BOOL)HandleMessage(VLB_SETTABSTOPS, numTabs, (LPARAM)tabs);
}

int TVListBox::SetTopIndex (long index)
{
	return (int)HandleMessage(VLB_SETTOPINDEX, 0, index);
}

UINT TVListBox::Transfer (void *buffer, TTransferDirection direction)//: returns the index of the first string in the associated listbox
	//+ which is the same as the passed string
	//+ 
	//+ searches for a match beginning at the passed indexStart
	//+ 
	//+ if a match is not found after the last string has been compared,
	//+ the search continues from the beginning of the list until a match
	//+ is found or until the list has been completely traversed
	//+ 
	//+ searches from beginning of list when -1 is passed as the index
	//+ 
	//+ returns the index of the selected string; a negative value is returned
	//+ if an error occurs
	//+ 
	//. for single or multiple-selection list boxes
{
	TVListBoxData*  vListBoxData = (TVListBoxData*)buffer;
	if ( vListBoxData == 0 )	throw xmsg ("null pointer in TVListBox::Transfer" );
	
	if (direction == tdGetData)
	{
		vListBoxData->SetItems ( items );
		vListBoxData->SetFocused ( GetSelIndex() ) ;
	}
	else if (direction == tdSetData) {
		NewList ( vListBoxData->GetItems () ) ;
		SetSelIndex ( vListBoxData->GetFocused () );
	}
	
	return sizeof(TVListBoxData);
}

char far * TVListBox::GetClassName ()//: transfers state information for a TListBox
	//+ 
	//+ transfers the items and selection of the list to or from a transfer
	//+ buffer if tdSetData or tdGetData, respectively, is passed as the
	//+ direction
	//+ 
	//+ buffer should point to a TListBoxData which points to the data to be
	//+ transferred
	//+ 
	//+ Transfer returns the size of TListBoxData
	//+ 
	//+ to retrieve the size without transferring data, pass tdSizeData as the
	//. direction
{
	return "VLIST";
}

void TVListBox::NewList (DBAbstractCollection* aList)
{
	#if	0
		BOOL diferentCollections = TRUE ;
		if ( items == 0 || aList == 0 )
			diferentCollections = TRUE ;
		else
			diferentCollections = ((*items) != (*aList));
		if (  diferentCollections )
		{
			items = aList;
			ClearList ();
		
			if ( items && items->GetCount() )
			{
				if ( items->GetWidth () > DisplayWidth )
					throw xmsg ("Collection too wide for this TVListBox" );
	
				SendMessage( VLB_INITIALIZE, 0, 0L );
				//	set horizontal extent
				TWindowDC dc (*this);
				TEXTMETRIC tm;
				dc.GetTextMetrics ( tm );
				unsigned cxChar = tm.tmAveCharWidth + 1 ;
				unsigned nChars = strlen ( items->AtAsAscii( 0L ) );
				SetHorizontalExtent ( cxChar*nChars );
			}
			else
			{
				SetHorizontalExtent ( 0 );
			}
		}
	#else	//	using clones
		BOOL diferentCollections = TRUE ;
		//	uno de los dos es 0 pero no los dos
		if ( (items == 0 || aList == 0) && !(items == 0 && aList == 0) )
			diferentCollections = TRUE ;
		else
		{
			if ((items != 0 && aList != 0) )	//	ninguno de los dos es 0
				diferentCollections = ((*items) != (*aList));
			else								//	ambos son 0
				diferentCollections = FALSE ;
		}
	
		if (  diferentCollections )
		{
			if ( aList != 0 )
			{
				delete items ;
				items = aList->Clone ();
			}
			else
			{
				delete items ;
				items = 0 ;
			}
			ClearList ();
	
			if ( items && items->GetCount() )
			{
				if ( items->GetWidth () > DisplayWidth )
					throw xmsg ("Collection too wide for this TVListBox" );
	
				SendMessage( VLB_INITIALIZE, 0, 0L );
				//	set horizontal extent
				TWindowDC dc (*this);
				TEXTMETRIC tm;
				dc.GetTextMetrics ( tm );
				unsigned cxChar = tm.tmAveCharWidth + 1 ;
				unsigned nChars = strlen ( items->AtAsAscii( 0L ) );
				SetHorizontalExtent ( cxChar*nChars );
			}
			else
			{
				SetHorizontalExtent ( 0 );
			}
		}	//	items != aList
	#endif
}

void TVListBox::SetTextPointer (LPVLBSTRUCT lpVLB)
{
	if ( items && items->GetCount() )
		strcpy( szText, items->AtAsAscii( lpVLB->lIndex ) );
	else
		szText [0] = 0 ;
	lpVLB->lpTextPointer = szText;
}

char TVListBox::szText[TVListBox::DisplayWidth];
VirtualRecordId TVListBox::Get () const 
{
	WARN ( items == 0, "items == 0 en PlanillaBrowser::Get()" );
	VirtualRecordId id ;	//	must be initialized with 0
	if ( items != 0 )
	{
		long focused = GetSelIndex () ;
		if ( focused > -1 )
			id = items->At ( focused ) ;
	}
	return id ;
}

long TVListBox::GetCount ()
{
	return items ? items->GetCount() : 0L ;
}

TVListBox::~TVListBox ()
{
	//	new with clones
	delete items ;
	items = 0 ;
}

TVListBoxData::TVListBoxData ()

 : items(0),
focused(-1)
{
	
}

TVListBoxData::~TVListBoxData ()
{
	delete items ; 
	items = 0 ;
}

VirtualRecordId TVListBoxData::GetVirtualRecordId ()
{
	if ( focused > -1 && items != 0 )
		return items->At ( focused );
	else
		return VirtualRecordId();	//	provided it initializes to 0
}

BOOL TVListBoxData::Select (VirtualRecordId id)
{
	long f = -1L ;
	if ( items != 0 )
	{
		f = items->GotoVirtualRecordId ( id );
	}
	SetFocused ( f );
	return f > -1 ;
}

VListDLL::VListDLL ()

 : TModule( "VLIST.DLL", TRUE )
{
	
}

const char* TVListBoxData::GetString ()
{
	if ( focused > -1 && items != 0 )
		return items->AtAsAscii ( focused );
	else
		return "";
}

