//. MODULE: TVDialog source

// @@DatatypeInclude
#ifndef INC_GLOBAL_HPP
#include "global.hpp"
#endif
// @@End
// @@Includes
#ifndef INC_TVDIALOG_HPP
#include "tvdialog.hpp"
#endif
// @@End
#ifndef INC_DBCOLLEC_HPP
#include "dbcollec.hpp"
#endif
#ifndef INC_TVLISTBO_HPP
#include "tvlistbo.hpp"
#endif
TVDialog::TVDialog (TWindow* parent, int resourceId, TModule* module)

 : TDialog ( parent, resourceId, module )
{
	
}

TVDialog::TVDialog (const TVDialog& rTVDialog)

 : TDialog ( rTVDialog.Parent, 1, rTVDialog.GetModule() )
{
	
}

DEFINE_RESPONSE_TABLE1( TVDialog, TDialog )
	EV_MESSAGE ( VLB_FIRST, VlbFirst ),
	EV_MESSAGE ( VLB_PREV, VlbPrev ),
	EV_MESSAGE ( VLB_NEXT, VlbNext ),
	EV_MESSAGE ( VLB_LAST, VlbLast ),
	EV_MESSAGE ( VLB_FINDPOS, VlbFindPos ),
	EV_MESSAGE ( VLB_FINDITEM, VlbFindItem ),
	EV_MESSAGE ( VLBR_FINDSTRING, VlbrFindString ),
	EV_MESSAGE ( VLBR_FINDSTRINGEXACT, VlbrFindStringExact ),
	EV_MESSAGE ( VLBR_SELECTSTRING, VlbrSelectString ),
	EV_MESSAGE ( VLBR_GETITEMDATA, VlbrGetItemData ),
	EV_MESSAGE ( VLBR_GETTEXT, VlbrGetText ),
	EV_MESSAGE ( VLB_RANGE, VlbRange ),
	

END_RESPONSE_TABLE;

LRESULT TVDialog::VlbFindItem (WPARAM, LPARAM lParam)
{
	LPVLBSTRUCT lpVLB = (LPVLBSTRUCT)lParam;
	
	lpVLB->lIndex = lpVLB->lData;
	lpVLB->nStatus = VLB_OK;
	GetTVListBox ( lpVLB->nCtlID )->SetTextPointer ( lpVLB ) ;
	
	return TRUE;
}

LRESULT TVDialog::VlbFindPos (WPARAM, LPARAM lParam)
{
	LPVLBSTRUCT lpVLB = (LPVLBSTRUCT)lParam;
	
	if ( lpVLB->lIndex == 0L ) {
		return VlbFirst ( 0, lParam ) ;
	}
	else if ( lpVLB->lIndex == 100L ) {
		return VlbLast ( 0, lParam ) ;
	}
	else {
		lpVLB->lIndex = lpVLB->lData*1000L;
	    lpVLB->nStatus = VLB_OK;
		GetTVListBox ( lpVLB->nCtlID )->SetTextPointer ( lpVLB ) ;
	    return TRUE;
	}
}

LRESULT TVDialog::VlbFirst (WPARAM, LPARAM lParam)
{
	LPVLBSTRUCT lpVLB = (LPVLBSTRUCT)lParam;
	lpVLB->nStatus = VLB_OK;
	lpVLB->lIndex = 0L;
	lpVLB->lData = lpVLB->lIndex;
	GetTVListBox ( lpVLB->nCtlID )->SetTextPointer ( lpVLB ) ;
	return TRUE;
}

LRESULT TVDialog::VlbLast (WPARAM, LPARAM lParam)
{
	LPVLBSTRUCT lpVLB = (LPVLBSTRUCT)lParam;
	TVListBox* pTVLB = GetTVListBox ( lpVLB->nCtlID );
	lpVLB->nStatus = VLB_OK;
	lpVLB->lIndex = max( pTVLB->GetCount() - 1, 0L ) ;
	lpVLB->lData = lpVLB->lIndex;
	pTVLB->SetTextPointer ( lpVLB ) ;
	return TRUE;
}

LRESULT TVDialog::VlbNext (WPARAM, LPARAM lParam)
{
	LPVLBSTRUCT lpVLB = (LPVLBSTRUCT)lParam;
	TVListBox* pTVLB =GetTVListBox ( lpVLB->nCtlID );
	
	if ( lpVLB->lIndex < max( pTVLB->GetCount()-1, 0L)) {
		lpVLB->nStatus = VLB_OK;
		lpVLB->lIndex++;
		lpVLB->lData = lpVLB->lIndex;
		pTVLB->SetTextPointer ( lpVLB ) ;
	}
	else {
		lpVLB->nStatus = VLB_ENDOFFILE;
	}
	return TRUE;
}

LRESULT TVDialog::VlbPrev (WPARAM, LPARAM lParam)
{
	LPVLBSTRUCT lpVLB = (LPVLBSTRUCT)lParam;
	
	if ( lpVLB->lIndex > 0 ) {
		lpVLB->nStatus = VLB_OK;
		lpVLB->lIndex--;
	    lpVLB->lData = lpVLB->lIndex;
		GetTVListBox ( lpVLB->nCtlID )->SetTextPointer ( lpVLB ) ;
	}
	else {
		lpVLB->nStatus = VLB_ENDOFFILE;
	}
	return TRUE;
}

LRESULT TVDialog::VlbRange (WPARAM, LPARAM lParam)
{
	LPVLBSTRUCT lpVLB = (LPVLBSTRUCT)lParam;
	lpVLB->lIndex = GetTVListBox ( lpVLB->nCtlID )->GetCount() ;
	lpVLB->nStatus = VLB_OK;
	return TRUE;
}

LRESULT TVDialog::VlbrFindString (WPARAM, LPARAM lParam)
{
	LPVLBSTRUCT lpVLB = (LPVLBSTRUCT)lParam;
	return CommonFindAndSelect ( lpVLB ) ;
}

LRESULT TVDialog::VlbrFindStringExact (WPARAM, LPARAM lParam)
{
	LPVLBSTRUCT lpVLB = (LPVLBSTRUCT)lParam;
	return CommonFindAndSelect ( lpVLB ) ;
}

LRESULT TVDialog::VlbrGetItemData (WPARAM, LPARAM lParam)
{
	LPVLBSTRUCT lpVLB = (LPVLBSTRUCT)lParam;
	
	lpVLB->nStatus = VLB_OK;
	lpVLB->lData = lpVLB->lIndex;
	return TRUE;
}

LRESULT TVDialog::VlbrGetText (WPARAM, LPARAM lParam)
{
	LPVLBSTRUCT lpVLB = (LPVLBSTRUCT)lParam;
	
	lpVLB->nStatus = VLB_OK;
	lpVLB->lData = lpVLB->lIndex;
	
	GetTVListBox ( lpVLB->nCtlID )->SetTextPointer ( lpVLB ) ;
	return TRUE;
}

LRESULT TVDialog::VlbrSelectString (WPARAM, LPARAM lParam)
{
	LPVLBSTRUCT lpVLB = (LPVLBSTRUCT)lParam;
	return CommonFindAndSelect ( lpVLB ) ;
}

BOOL TVDialog::CommonFindAndSelect (LPVLBSTRUCT lpVLB)
{
	lpVLB->lData = lpVLB->lIndex = atol( lpVLB->lpFindString );
	lpVLB->nStatus = VLB_OK;
	
	GetTVListBox ( lpVLB->nCtlID )->SetTextPointer ( lpVLB ) ;
	return TRUE;
}

TVListBox * TVDialog::GetTVListBox (int ctlId)
{
	TWindow* win = FirstThat ( (TCondMemFunc)&TVDialog::HasAttrId, (void*)&ctlId );
	if ( win == 0 )
		throw xmsg ("TVListBox with specified id not found !");
	TVListBox* pvL = dynamic_cast<TVListBox*> (win);
	return pvL ;
}

BOOL TVDialog::HasAttrId (TWindow* win, void* param)
{
	return win->Attr.Id == (*(int*)param) ;
}

