#ifndef INC_PLANOWL_HPP
#define INC_PLANOWL_HPP

//. MODULE: PlanOWL

// @@DatatypeInclude
#ifndef INC_GLOBAL_HPP
#include "global.hpp"
#endif
// @@End
// @@Includes
#ifndef INC_TVLISTBO_HPP
#include "tvlistbo.hpp"
#endif
#ifndef INC_OBJECTS_HPP
#include "objects.hpp"
#endif
#ifndef INC_TVDIALOG_HPP
#include "tvdialog.hpp"
#endif
#ifndef INC_GLOBAL_HPP
#include "global.hpp"
#endif
// @@End
struct TransferPlanillaBrowser

{
	public:
		TVListBoxData vlbPlanillas;
		TransferPlanillaBrowser (Planilla& plan);
	protected:
		Planilla& planilla;
	public:
		void Commit ();
	protected:
		DBPlanillaIdCollection* pPlanillaCol;
	public:
		~TransferPlanillaBrowser ();
};

class PlanillaBrowser : public TVDialog//; Database viewer - a specialized TListViewer that knows how to display persistent collections.

{
	public:
		PlanillaBrowser (TWindow* parent, TransferPlanillaBrowser& ts, TModule* module = 0);//; list box attributes
	private:
		PlanillaBrowser (const PlanillaBrowser& rDbBrowser);
	public:
		DECLARE_RESPONSE_TABLE(PlanillaBrowser);
	protected:
		void EvListBoxDblClk ();
		TVListBox* pvListBox;
		virtual void SetupWindow ();
		void CmIdOk ();
	public:
		//. list box attributes
};

class TransferPlanillaEditor

{
	public:
		TVListBoxData vlbCompanias;
		TVListBoxData vlbProyectos;
		char caPeriodo [3];
		char caFechaPlan [9];
		TransferPlanillaEditor (Planilla& plan);
		void Commit ();
	protected:
		Planilla& planilla;
		DBCompaniaCollection* pCompaniaCol;
		DBProyectosDeCompania* pProyectosCol;
	public:
		~TransferPlanillaEditor ();
};

class PlanillaEditor : public TVDialog

{
	public:
		PlanillaEditor (TWindow* parent, TransferPlanillaEditor& ts, TModule* module = 0);//; list box attributes
	private:
		PlanillaEditor (const PlanillaEditor& rPE);
	protected:
		TVListBox* pvlbCompanias;
		virtual void SetupWindow ();
		TVListBox* pvlbProyectos;
		TEdit* pePeriodo;
		TEdit* peFechaPlan;
	public:
		DECLARE_RESPONSE_TABLE(PlanillaEditor);
	protected:
		void EvCompaniasSelChange ();
		TransferPlanillaEditor& transfer;
		void CmRevert ();
		DBProyectosDeCompania* pProyectosCol;
	public:
		virtual ~PlanillaEditor ();
		//. list box attributes
};

class TransferPersonaEditor

{
	public:
		WORD wTipoCedula;
		WORD wTipoPasaporte;
		WORD wTipoPP;
		char caIdEmp [16];
		char caNombre [21];
		char caApellidos [21];
		char caNumSeguro [9];
		TVListBoxData vlbPaises;
		char caNacio [9];
		TransferPersonaEditor (Empleado& emp);
		void Commit () throw (xmsg);
	protected:
		Empleado& empleado;
		DBNacionalidades* pNacionalidades;
	public:
		~TransferPersonaEditor ();
};

class PersonaEditor : public TVDialog

{
	public:
		PersonaEditor (TWindow* parent, TransferPersonaEditor& ts, TModule* module = 0);//; list box attributes
	private:
		PersonaEditor (const PersonaEditor& rPE);
	protected:
		virtual void SetupWindow ();
	public:
		DECLARE_RESPONSE_TABLE(PersonaEditor);
	protected:
		TransferPersonaEditor& transfer;
		void CmRevert ();
	public:
		virtual ~PersonaEditor ();
	protected:
		TRadioButton* prbTipoCedula;
		TRadioButton* prbTipoPasaporte;
		TRadioButton* prbTipoPP;
		TEdit* peIdentificacion;
		TEdit* peNombre;
		TEdit* peApellidos;
		TEdit* peNumSeguro;
		TVListBox* pvlbPaises;
		TEdit* peNacio;
};

struct TransferPersonaBrowser

{
	public:
		TVListBoxData vlbEmpleados;
		TransferPersonaBrowser (Empleado& emp);
	protected:
		Empleado& empleado;
	public:
		void Commit ();
	protected:
		DBEmpleadoIdCollection* pEmpleadoCol;
	public:
		~TransferPersonaBrowser ();
};

class PersonaBrowser : public TVDialog//; Database viewer - a specialized TListViewer that knows how to display persistent collections.

{
	public:
		PersonaBrowser (TWindow* parent, TransferPersonaBrowser& ts, TModule* module = 0);//; list box attributes
	private:
		PersonaBrowser (const PersonaBrowser& rDbBrowser);
	public:
		DECLARE_RESPONSE_TABLE(PersonaBrowser);
	protected:
		void EvListBoxDblClk ();
		TVListBox* pvListBox;
		virtual void SetupWindow ();
		void CmIdOk ();
};


#endif
