//. MODULE: PlanOWL source

// @@DatatypeInclude
#ifndef INC_GLOBAL_HPP
#include "global.hpp"
#endif
// @@End
// @@Includes
#ifndef INC_PLANOWL_HPP
#include "planowl.hpp"
#endif
// @@End
#ifndef INC_TESIS2_RH
#include "tesis2.rh"
#endif
#ifndef INC_TVLISTBO_HPP
#include "tvlistbo.hpp"
#endif
#ifndef INC_APPCOLLE_HPP
#include "appcolle.hpp"
#endif
PlanillaBrowser::PlanillaBrowser (TWindow* parent, TransferPlanillaBrowser& ts, TModule* module)

 : TVDialog ( parent, PLANILLA_BROWSER, module ),
// @@OEW generated
pvListBox(0)
{
	pvListBox = new TVListBox ( this, IDC_PLANILLAS ) ;
	SetTransferBuffer ( &ts );
}

PlanillaBrowser::PlanillaBrowser (const PlanillaBrowser& rDbBrowser)

 : TVDialog ( rDbBrowser.Parent, -1, rDbBrowser.GetModule() ),
// @@OEW generated
pvListBox(0)
{
	
}

DEFINE_RESPONSE_TABLE1( PlanillaBrowser, TVDialog )
	EV_LBN_DBLCLK ( IDC_PLANILLAS, EvListBoxDblClk ),
	EV_COMMAND ( IDOK, CmIdOk ),
	
	

END_RESPONSE_TABLE;

void PlanillaBrowser::EvListBoxDblClk ()
{
	// selection made, end execute
	CmIdOk ();
}

void PlanillaBrowser::SetupWindow ()
{
		TVDialog::SetupWindow ();
	
		int Tabs[2] = { 80, 200 };
		pvListBox->SetTabStops( 2, Tabs );
		//		pvListBox->SendMessage( VLB_SETTABSTOPS, 2, (LPARAM)((int FAR *)Tabs) );
	
		HGDIOBJ hFont = GetStockObject ( ANSI_FIXED_FONT );
		pvListBox->SendMessage ( WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
	
		// center
		CHECK ( Parent != 0 );
	//	CenterChild ( Parent, this ) ;
}

void PlanillaBrowser::CmIdOk ()
{
	CloseWindow ( IDOK ) ;
}

PlanillaEditor::PlanillaEditor (TWindow* parent, TransferPlanillaEditor& ts, TModule* module)

 : TVDialog ( parent, PLANILLA_EDITOR, module ),
transfer ( ts ),
pvlbCompanias(0),
pvlbProyectos(0),
pePeriodo(0),
peFechaPlan(0),
pProyectosCol(0)
{
	pvlbCompanias = new TVListBox ( this, IDC_COMPANIAS ) ;
	pvlbProyectos = new TVListBox ( this, IDC_PROYECTOS ) ;
	pePeriodo = new TEdit ( this, IDC_PERIODO, sizeof (ts.caPeriodo) );
	peFechaPlan = new TEdit ( this, IDC_FECHAPLAN, sizeof (ts.caFechaPlan) );
	
	SetTransferBuffer ( &ts );
}

PlanillaEditor::PlanillaEditor (const PlanillaEditor& rPE)

 : TVDialog ( rPE.Parent, -1, rPE.GetModule() ),
transfer( TransferPlanillaEditor( Planilla () ) )
,
// @@OEW generated
pvlbCompanias(0),
pvlbProyectos(0),
pePeriodo(0),
peFechaPlan(0),
pProyectosCol(0)
{
	
}

void PlanillaEditor::SetupWindow ()//: change name !!
	//. change name !!
{
	TVDialog::SetupWindow ();
	// center
	CHECK ( Parent != 0 );
	//	CenterChild ( Parent, this ) ;
}

DEFINE_RESPONSE_TABLE1( PlanillaEditor, TVDialog )
	EV_LBN_SELCHANGE ( IDC_COMPANIAS, EvCompaniasSelChange ),
	EV_COMMAND ( IDC_REVERT, CmRevert ),
	
	

END_RESPONSE_TABLE;

void PlanillaEditor::EvCompaniasSelChange ()//; change name !!
{
	#if 0	//	transferring more than necessary
		TransferData ( tdGetData );
		VirtualRecordId id = transfer.vlbCompanias.GetVirtualRecordId ();
		transfer.vlbProyectos.SetItems ( new DBProyectosDeCompania ( id[0] ) );
		TransferData ( tdSetData );
	#elif 0	//	doesn't support revert
		pvlbCompanias->Transfer ( &transfer.vlbCompanias, tdGetData );
		VirtualRecordId id = transfer.vlbCompanias.GetVirtualRecordId ();
		transfer.vlbProyectos.SetItems ( new DBProyectosDeCompania ( id[0] ) );
		pvlbProyectos->Transfer ( &transfer.vlbProyectos, tdSetData );
	#else
		TVListBoxData vlbCompaniaData ;
		pvlbCompanias->Transfer ( &vlbCompaniaData, tdGetData );
		VirtualRecordId id = vlbCompaniaData.GetVirtualRecordId ();
		DBProyectosDeCompania* saveCol = pProyectosCol ;
		pProyectosCol = new DBProyectosDeCompania ( id[0] ) ;
		TVListBoxData vlbProyectosData ;
		vlbProyectosData.SetItems ( pProyectosCol );
		pvlbProyectos->Transfer ( &vlbProyectosData, tdSetData );
		delete saveCol ;
	#endif
}

TransferPlanillaBrowser::TransferPlanillaBrowser (Planilla& plan)

 : planilla ( plan ),
// @@OEW generated
pPlanillaCol(0)
{
	pPlanillaCol = new DBPlanillaIdCollection ;
	vlbPlanillas.SetItems ( pPlanillaCol );
}

void TransferPlanillaBrowser::Commit ()
{
	//	pass into plan object
	VirtualRecordId id = vlbPlanillas.GetVirtualRecordId() ;
	planilla [ DbAddr ( id[0] ) ];
}

TransferPlanillaEditor::TransferPlanillaEditor (Planilla& plan)

 : planilla (plan),
// @@OEW generated
pCompaniaCol(0),
pProyectosCol(0)
{
	char msg [ 200 ];
	pCompaniaCol = new DBCompaniaCollection ;
	
	//	companias
	vlbCompanias.SetItems ( pCompaniaCol );
	if ( planilla.GetDba () > 0L )
	{
		Compania comp = planilla.GetCompania ();	//	is an attribute of planilla !
		vlbCompanias.Select ( comp.GetDba() );
	
	//	proyectos (empty while compania not selected)
		pProyectosCol = new DBProyectosDeCompania ( comp ) ;
		vlbProyectos.SetItems ( pProyectosCol );
	
		Proyecto proy = planilla.GetProyecto ();
		vlbProyectos.Select ( proy.GetDba() );
	
	
		//	periodo
		itoa ( planilla.GetPeriodo (), msg, 10 );
		msg [ sizeof (caPeriodo) - 1 ] = 0;
		strcpy ( caPeriodo, msg );
	
		//	fecha planilla
		TDate :: HowToPrint htpCur = TDate :: SetPrintOption ( TDate :: EuropeanNumbers );
		string sdate = planilla.GetFechaPlanilla ().AsString () ;
		TDate :: SetPrintOption ( htpCur );
	
		sdate.copy ( caFechaPlan, sizeof(caFechaPlan));
	}
	else
	{
		strcpy ( caPeriodo, "7" );
		//	fecha planilla
		TDate :: HowToPrint htpCur = TDate :: SetPrintOption ( TDate :: EuropeanNumbers );
		string sdate = TDate().AsString();
		TDate :: SetPrintOption ( htpCur );
		sdate.copy ( caFechaPlan, sizeof(caFechaPlan));	
	}
}

void TransferPlanillaEditor::Commit ()
{
	//	pass into plan object
	
	//	proyecto
	VirtualRecordId vridProy = vlbProyectos.GetVirtualRecordId ();
	Proyecto proy ;
	proy [ DbAddr ( vridProy[0] ) ];
	// planilla.SetProyecto ( vridProy[0] );
	
	//	periodo
	int p = atoi ( caPeriodo );
	planilla.SetPeriodo ( p );
	
	//	fecha planilla
	istrstream is ( caFechaPlan );
	TDate date ( is );
	planilla.SetFechaPlanilla ( date ) ;
	
	if ( planilla.GetDba () > 0L )
	{
		planilla.Update ( proy );
	}
	else
	{
		planilla.New ( proy );
	}
}

void PlanillaEditor::CmRevert ()
{
	TransferData ( tdSetData ) ;
	UpdateWindow () ;
}

TransferPlanillaEditor::~TransferPlanillaEditor ()
{
	delete pCompaniaCol ; pCompaniaCol = 0;
	delete pProyectosCol ; pProyectosCol = 0;
}

PlanillaEditor::~PlanillaEditor ()
{
	delete pProyectosCol ; pProyectosCol = 0;
}

TransferPlanillaBrowser::~TransferPlanillaBrowser ()
{
	delete pPlanillaCol ; pPlanillaCol = 0;
}

TransferPersonaEditor::TransferPersonaEditor (Empleado& emp)

 : empleado (emp )
,
// @@OEW generated
wTipoCedula(0),
wTipoPasaporte(0),
wTipoPP(0),
pNacionalidades(0)
{
	TDate :: HowToPrint htpCur = TDate :: SetPrintOption ( TDate :: EuropeanNumbers );
	pNacionalidades = new DBNacionalidades ;
	
	//	companias
	vlbPaises.SetItems ( pNacionalidades );
	if ( empleado.GetDba () > 0L )
	{
		Pais pais = empleado.GetPaisDeOrigen() ;
		vlbPaises.Select ( pais.GetDba() );
		wTipoCedula = wTipoPasaporte = wTipoPP = 0;
			
		empleado.GetId ().copy ( caIdEmp, sizeof(caIdEmp));
		empleado.GetApellidos().copy ( caApellidos, sizeof(caApellidos));
		empleado.GetNombre().copy ( caNombre, sizeof(caNombre));
		empleado.GetNumAsegurado().copy ( caNumSeguro, sizeof(caNumSeguro));
		empleado.GetFechaNacimiento().AsString ().copy ( caNacio, sizeof(caNacio));
		switch ( empleado.GetIdType () )
		{
			case EmpleadoObj::Cedula:
				wTipoCedula = BF_CHECKED ;
				break;
			case EmpleadoObj::Pasaporte:
				wTipoPasaporte = BF_CHECKED ;
				break;
			case EmpleadoObj::PermisoPatronal:
				wTipoPP = BF_CHECKED ;
				break ;
		}
	}
	else
	{
		wTipoCedula = BF_CHECKED ;
		wTipoPasaporte = wTipoPP = 0;
		caIdEmp[0] = 0 ; 
		caApellidos[0] = 0 ;
		caNombre[0] = 0 ;
		caNumSeguro[0] = 0 ;
		TDate().AsString ().copy ( caNacio, sizeof(caNacio));
	}
	TDate :: SetPrintOption ( htpCur );
}

void TransferPersonaEditor::Commit () throw (xmsg)
{
	//	pais
	VirtualRecordId vridPais = vlbPaises.GetVirtualRecordId ();
	Pais pais ;
	pais [ DbAddr ( vridPais[0] ) ];
	
	
	istrstream is ( caNacio );
	TDate date ( is );
	empleado.SetFechaNacimiento ( date ) ;
	empleado.SetId ( caIdEmp ) ;
	empleado.SetApellidos ( caApellidos ) ;
	empleado.SetNombre ( caNombre ) ;
	empleado.SetNumAsegurado ( caNumSeguro ) ;
	
	if ( wTipoCedula )
	{
		empleado.SetIdType ( EmpleadoObj::Cedula ) ;
	}
	else if ( wTipoPasaporte )
	{
		empleado.SetIdType ( EmpleadoObj::Pasaporte ) ;
	}
	else if ( wTipoPP )
	{
		empleado.SetIdType ( EmpleadoObj::PermisoPatronal ) ;
	}
	else
		throw xmsg ("empleado id type unknown !" );
	
	
	if ( empleado.GetDba () > 0L )
	{
		empleado.Update ( pais );
	}
	else
	{
		empleado.New ( pais );
	}
}

TransferPersonaEditor::~TransferPersonaEditor ()
{
	delete pNacionalidades ; pNacionalidades = 0;
}

PersonaEditor::PersonaEditor (TWindow* parent, TransferPersonaEditor& ts, TModule* module)

 : TVDialog ( parent, PERSONA_EDITOR, module ),
transfer ( ts ),
// @@OEW generated
prbTipoCedula(0),
prbTipoPasaporte(0),
prbTipoPP(0),
peIdentificacion(0),
peNombre(0),
peApellidos(0),
peNumSeguro(0),
pvlbPaises(0),
peNacio(0)
{
	prbTipoCedula = new TRadioButton ( this, IDC_TIPO_CEDULA, 0 ) ;
	prbTipoPasaporte = new TRadioButton ( this, IDC_TIPO_PASAPORTE, 0 ) ;
	prbTipoPP = new TRadioButton ( this, IDC_TIPO_PP, 0 ) ;
	peIdentificacion = new TEdit ( this, IDC_IDENTIFICACION, sizeof (ts.caIdEmp) );
	peNombre = new TEdit ( this, IDC_NOMBRE, sizeof (ts.caNombre) );
	peApellidos = new TEdit ( this, IDC_APELLIDOS, sizeof (ts.caApellidos) );
	peNumSeguro = new TEdit ( this, IDC_NUM_ASEGURADO, sizeof (ts.caNumSeguro) );
	pvlbPaises = new TVListBox ( this, IDC_NACIONALIDAD ) ;
	peNacio = new TEdit ( this, IDC_NACIMIENTO, sizeof (ts.caNacio) );
	
	SetTransferBuffer ( &ts );
}

PersonaEditor::PersonaEditor (const PersonaEditor& rPE)

 : TVDialog ( rPE.Parent, -1, rPE.GetModule() ),
transfer( TransferPersonaEditor( Empleado () ) )
,
// @@OEW generated
prbTipoCedula(0),
prbTipoPasaporte(0),
prbTipoPP(0),
peIdentificacion(0),
peNombre(0),
peApellidos(0),
peNumSeguro(0),
pvlbPaises(0),
peNacio(0)
{
	
}

void PersonaEditor::SetupWindow ()//: change name !!
	//. change name !!
{
	TVDialog::SetupWindow ();
	// center
	CHECK ( Parent != 0 );
	//	CenterChild ( Parent, this ) ;
}

DEFINE_RESPONSE_TABLE1( PersonaEditor, TVDialog )
	EV_COMMAND ( IDC_REVERT, CmRevert ),
	
	

END_RESPONSE_TABLE;

void PersonaEditor::CmRevert ()
{
	TransferData ( tdSetData ) ;
	UpdateWindow () ;
}

PersonaEditor::~PersonaEditor ()
{
	
}

TransferPersonaBrowser::TransferPersonaBrowser (Empleado& emp)

 : empleado ( emp ),
// @@OEW generated
pEmpleadoCol(0)
{
	pEmpleadoCol = new DBEmpleadoIdCollection ;
	vlbEmpleados.SetItems ( pEmpleadoCol );
}

void TransferPersonaBrowser::Commit ()
{
	//	pass into plan object
	VirtualRecordId id = vlbEmpleados.GetVirtualRecordId() ;
	empleado [ DbAddr ( id[0] ) ];
}

TransferPersonaBrowser::~TransferPersonaBrowser ()
{
	delete pEmpleadoCol ; pEmpleadoCol = 0;
}

PersonaBrowser::PersonaBrowser (TWindow* parent, TransferPersonaBrowser& ts, TModule* module)

 : TVDialog ( parent, EMPLEADO_BROWSER, module ),
// @@OEW generated
pvListBox(0)
{
	pvListBox = new TVListBox ( this, IDC_EMPLEADOS ) ;
	SetTransferBuffer ( &ts );
}

PersonaBrowser::PersonaBrowser (const PersonaBrowser& rDbBrowser)

 : TVDialog ( rDbBrowser.Parent, -1, rDbBrowser.GetModule() ),
// @@OEW generated
pvListBox(0)
{
	
}

DEFINE_RESPONSE_TABLE1( PersonaBrowser, TVDialog )
	EV_LBN_DBLCLK ( IDC_EMPLEADOS, EvListBoxDblClk ),
	EV_COMMAND ( IDOK, CmIdOk ),

END_RESPONSE_TABLE;

void PersonaBrowser::EvListBoxDblClk ()
{
	// selection made, end execute
	CmIdOk ();
}

void PersonaBrowser::SetupWindow ()
{
	TVDialog::SetupWindow ();
	
	int Tabs[2] = { 84, 168 };
	pvListBox->SetTabStops( 2, Tabs );
	
	HGDIOBJ hFont = GetStockObject ( ANSI_FIXED_FONT );
	pvListBox->SendMessage ( WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
}

void PersonaBrowser::CmIdOk ()
{
	CloseWindow ( IDOK ) ;
}

