//. MODULE: DbTempObjs source

// @@DatatypeInclude
#ifndef INC_GLOBAL_HPP
#include "global.hpp"
#endif
// @@End
// @@Includes
#ifndef INC_DBTEMPOB_HPP
#include "dbtempob.hpp"
#endif
// @@End
#ifndef INC_VIRRECID_HPP
#include "virrecid.hpp"
#endif
void DBSortedSmallCollectionElement::First (DBCollectionNode& node)
{
	node >> (*this) ;
}

BOOL DBSortedSmallCollectionElement::New (DBCollectionNode& node)
{
	NewObj () ;
	if ( Okay () )
	{
		Connect ( node ) ;
	//	Connect ( static_cast<CollectionNodeObj&>(node) ) ;
	}
	return Okay () ;
}

unsigned long DBSortedSmallCollectionElement::GetCount (DBCollectionNode& node)
{
	return node.Members ( *this ) ;
}

void DBSortedSmallCollectionElement::Last ()
{
	WARN ( ! Okay (), "! Okay() in Last on a collection element" );
	(*this) [LAST] ;
}

void DBSortedSmallCollectionElement::Next ()
{
	WARN ( ! Okay (), "! Okay() in Next on a collection element" );
	(*this)++ ;
}

BOOL DBSortedSmallCollectionElement::Okay () const 
{
	return StoreObj :: Okay () ;
}

void DBSortedSmallCollectionElement::Prev ()
{
	WARN ( ! Okay (), "! Okay() in Prev on a collection element" );
	(*this)--;
}

void DBSortedSmallCollectionElement::SetStatus (int s)
{
	StoreObj :: SetStatus ( s ) ;
}

void DBSortedSmallCollectionElement::SetString (const char* linea)
{
	SetPString ( linea ) ;
}

CollectionNodeObj::CollectionNodeObj ()

{
	
}

CollectionNodeObj::~CollectionNodeObj ()
{
	
}

void CollectionNodeObj::SetId (unsigned long id)
{
	collectionId = id ;
}

unsigned long CollectionNodeObj::GetId () const 
{
	return collectionId ;
}

SSCollectionElementsObj::SSCollectionElementsObj ()

 : StoreObj(SetObj(SSCOLLECTION))
{
	
}

SSCollectionElementsObj::~SSCollectionElementsObj ()
{
	
}

void SSCollectionElementsObj::SetPString (const char* linea)
{
	strncpy ( sortElemS, linea, sizeof sortElemS ) ;
	sortElemS [ sizeof sortElemS - 1 ] = 0 ;
}

void SSCollectionElementsObj::SetPKey (const char* key)
{
	strncpy ( collKeyS, key, sizeof collKeyS ) ;
	collKeyS [ sizeof collKeyS - 1 ] = 0 ;
}

SCollectionElementsObj::SCollectionElementsObj ()

 : StoreObj(SetObj(COLLECTION))
{
	
}

SCollectionElementsObj::~SCollectionElementsObj ()
{
	
}

void SCollectionElementsObj::SetPKey (const char* key)
{
	WARN ( key != 0, "calling SetPKey on an unsorted element" );
}

void SCollectionElementsObj::SetPString (const char* linea)
{
	strncpy ( elemS, linea, sizeof elemS ) ;
	elemS [ sizeof elemS - 1 ] = 0 ;
}

LSCollectionElementsObj::LSCollectionElementsObj ()

 : StoreObj(SetObj(LSCOLLECTION))
{
	
}

LSCollectionElementsObj::~LSCollectionElementsObj ()
{
	
}

void LSCollectionElementsObj::SetPKey (const char* key)
{
	strncpy ( collKeyL, key, sizeof collKeyL ) ;
	collKeyL [ sizeof collKeyL - 1 ] = 0 ;
}

void LSCollectionElementsObj::SetPString (const char* linea)
{
	strncpy ( sortElemL, linea, sizeof sortElemL ) ;
	sortElemL [ sizeof sortElemL - 1 ] = 0 ;
}

LCollectionElementsObj::LCollectionElementsObj ()

 : StoreObj(SetObj(COLLECTION))
{
	
}

LCollectionElementsObj::~LCollectionElementsObj ()
{
	
}

void LCollectionElementsObj::SetPKey (const char* key)
{
	WARN ( key != 0, "calling SetPKey on an unsorted element" );
}

void LCollectionElementsObj::SetPString (const char* linea)
{
	strncpy ( elemL, linea, sizeof elemL ) ;
	elemL [ sizeof elemL - 1 ] = 0 ;
}

BOOL CollectionNodeObj::New ()
{
	NewObj () ;
	return Okay () ;
}

DBCollectionNode::DBCollectionNode (unsigned long id)

{
	SetId ( id ) ;
}

DBCollectionNode::~DBCollectionNode ()
{
	
}

void DBSmallCollectionElement::First (DBCollectionNode& node)
{
	node >> (*this) ;
}

unsigned long DBSmallCollectionElement::GetCount (DBCollectionNode& node)
{
	return node.Members ( *this ) ;
}

void DBSmallCollectionElement::Last ()
{
	WARN ( ! Okay (), "! Okay() in Last on a collection element" );
	(*this) [LAST] ;
}

BOOL DBSmallCollectionElement::New (DBCollectionNode& node)
{
	NewObj () ;
	if ( Okay () )
	{
		Connect ( node ) ;
	//	Connect ( static_cast<CollectionNodeObj&>(node) ) ;
	}
	return Okay () ;
}

void DBSmallCollectionElement::Next ()
{
	WARN ( ! Okay (), "! Okay() in Next on a collection element" );
	(*this)++ ;
}

BOOL DBSmallCollectionElement::Okay () const 
{
	return StoreObj :: Okay () ;
}

void DBSmallCollectionElement::Prev ()
{
	WARN ( ! Okay (), "! Okay() in Prev on a collection element" );
	(*this)--;
}

void DBSmallCollectionElement::SetStatus (int s)
{
	StoreObj :: SetStatus ( s ) ;
}

void DBSmallCollectionElement::SetString (const char* linea)
{
	SetPString ( linea ) ;
}

void DBLargeCollectionElement::First (DBCollectionNode& node)
{
	node >> (*this) ;
}

unsigned long DBLargeCollectionElement::GetCount (DBCollectionNode& node)
{
	return node.Members ( *this ) ;
}

void DBLargeCollectionElement::Last ()
{
	WARN ( ! Okay (), "! Okay() in Last on a collection element" );
	(*this) [LAST] ;
}

BOOL DBLargeCollectionElement::New (DBCollectionNode& node)
{
	NewObj () ;
	if ( Okay () )
	{
		Connect ( node ) ;
	//	Connect ( static_cast<CollectionNodeObj&>(node) ) ;
	}
	return Okay () ;
}

void DBLargeCollectionElement::Next ()
{
	WARN ( ! Okay (), "! Okay() in Next on a collection element" );
	(*this)++ ;
}

BOOL DBLargeCollectionElement::Okay () const 
{
	return StoreObj :: Okay () ;
}

void DBLargeCollectionElement::Prev ()
{
	WARN ( ! Okay (), "! Okay() in Prev on a collection element" );
	(*this)--;
}

void DBLargeCollectionElement::SetStatus (int s)
{
	StoreObj :: SetStatus ( s ) ;
}

void DBLargeCollectionElement::SetString (const char* linea)
{
	SetPString ( linea ) ;
}

void DBSortedLargeCollectionElement::First (DBCollectionNode& node)
{
	node >> (*this) ;
}

unsigned long DBSortedLargeCollectionElement::GetCount (DBCollectionNode& node)
{
	return node.Members ( *this ) ;
}

void DBSortedLargeCollectionElement::Last ()
{
	WARN ( ! Okay (), "! Okay() in Last on a collection element" );
	(*this) [LAST] ;
}

BOOL DBSortedLargeCollectionElement::New (DBCollectionNode& node)
{
	NewObj () ;
	if ( Okay () )
	{
		Connect ( node ) ;
		//	Connect ( static_cast<CollectionNodeObj&>(node) ) ;
	}
	return Okay () ;
}

void DBSortedLargeCollectionElement::Next ()
{
	WARN ( ! Okay (), "! Okay() in Next on a collection element" );
	(*this)++ ;
}

BOOL DBSortedLargeCollectionElement::Okay () const 
{
	return StoreObj :: Okay () ;
}

void DBSortedLargeCollectionElement::Prev ()
{
	WARN ( ! Okay (), "! Okay() in Prev on a collection element" );
	(*this)--;
}

void DBSortedLargeCollectionElement::SetStatus (int s)
{
	StoreObj :: SetStatus ( s ) ;
}

void DBSortedLargeCollectionElement::SetString (const char* linea)
{
	SetPString ( linea ) ;
}

void SSCollectionElementsObj::SetPVirtualRecordId (const VirtualRecordId& rec_ids)
{
	rec_ids.CopyTo ( dbaSS ) ;
}

VirtualRecordId SSCollectionElementsObj::GetPVirtualRecordId () const 
{
	return VirtualRecordId ( dbaSS ) ;
}

VirtualRecordId SCollectionElementsObj::GetPVirtualRecordId () const 
{
	return VirtualRecordId ( dbaS ) ;
}

void SCollectionElementsObj::SetPVirtualRecordId (const VirtualRecordId& rec_ids)
{
	rec_ids.CopyTo ( dbaS ) ;
}

VirtualRecordId LCollectionElementsObj::GetPVirtualRecordId () const 
{
	return VirtualRecordId ( dbaL ) ;
}

void LCollectionElementsObj::SetPVirtualRecordId (const VirtualRecordId& rec_ids)
{
	rec_ids.CopyTo ( dbaL ) ;
}

VirtualRecordId LSCollectionElementsObj::GetPVirtualRecordId () const 
{
	return VirtualRecordId ( dbaLS ) ;
}

void LSCollectionElementsObj::SetPVirtualRecordId (const VirtualRecordId& rec_ids)
{
	rec_ids.CopyTo ( dbaLS ) ;
}

long DBSortedSmallCollectionElement::GotoVirtualRecordId (VirtualRecordId& id)
{
	Find ( KeyObj(REC_SSCOLLECTIONELEMENTS_DBASS, (void*)&id[0]) );
	return Okay () ? GetSequence () : -1L ;
}

long DBSmallCollectionElement::GotoVirtualRecordId (VirtualRecordId& id)
{
	Find ( KeyObj(REC_SCOLLECTIONELEMENTS_DBAS, (void*)&id[0]) );
	return Okay () ? GetSequence () : -1L ;
}

long DBLargeCollectionElement::GotoVirtualRecordId (VirtualRecordId& id)
{
	Find ( KeyObj(REC_LCOLLECTIONELEMENTS_DBAL, (void*)&id[0]) );
	return Okay () ?  GetSequence () : -1L ;
}

long DBSortedLargeCollectionElement::GotoVirtualRecordId (VirtualRecordId& id)
{
	Find ( KeyObj(REC_LSCOLLECTIONELEMENTS_DBALS, (void*)&id[0]) );
	return Okay () ? GetSequence () : -1L ;
}

SSCollectionElementsObj& SSCollectionElementsObj::operator = (const SSCollectionElementsObj& op)
{
	StoreObj :: operator=( (RStoreObj) op );
	if ( GetDba() != 0 )
	{
		CrSet ();
		Read ();
	}
	return *this;
}

SCollectionElementsObj& SCollectionElementsObj::operator = (const SCollectionElementsObj& op)
{
	StoreObj :: operator=( (RStoreObj) op );
	if ( GetDba() != 0 )
	{
		CrSet ();
		Read ();
	}
	return *this;
}

LCollectionElementsObj& LCollectionElementsObj::operator = (const LCollectionElementsObj& op)
{
	StoreObj :: operator=( (RStoreObj) op );
	if ( GetDba() != 0 )
	{
		CrSet ();
		Read ();
	}
	return *this;
}

LSCollectionElementsObj& LSCollectionElementsObj::operator = (const LSCollectionElementsObj& op)
{
	StoreObj :: operator=( (RStoreObj) op );
	if ( GetDba() != 0 )
	{
		CrSet ();
		Read ();
	}
	return *this;
}

SSCollectionElementsObj::SSCollectionElementsObj (const SSCollectionElementsObj& op)

 : StoreObj ( (RStoreObj) op )
{
	if ( GetDba() != 0 )
	{
		CrSet ();
		Read ();
	}
}

SCollectionElementsObj::SCollectionElementsObj (const SCollectionElementsObj& op)

 : StoreObj ( (RStoreObj) op )
{
	if ( GetDba() != 0 )
	{
		CrSet ();
		Read ();
	}
}

LCollectionElementsObj::LCollectionElementsObj (const LCollectionElementsObj& op)

 : StoreObj ( (RStoreObj) op )
{
	if ( GetDba() != 0 )
	{
		CrSet ();
		Read ();
	}
}

LSCollectionElementsObj::LSCollectionElementsObj (const LSCollectionElementsObj& op)

 : StoreObj ( (RStoreObj) op )
{
	if ( GetDba() != 0 )
	{
		CrSet ();
		Read ();
	}
}

DBSortedSmallCollectionElement::DBSortedSmallCollectionElement (const DBSortedSmallCollectionElement& op)

 : SSCollectionElementsObj ( op )
{
	
}

DBSortedSmallCollectionElement::DBSortedSmallCollectionElement ()

{
	
}

DBSmallCollectionElement::DBSmallCollectionElement (const DBSmallCollectionElement& op)

 : SCollectionElementsObj ( op )
{
	
}

DBSmallCollectionElement::DBSmallCollectionElement ()

{
	
}

DBLargeCollectionElement::DBLargeCollectionElement (const DBLargeCollectionElement& op)

 : LCollectionElementsObj ( op )
{
	
}

DBLargeCollectionElement::DBLargeCollectionElement ()

{
	
}

DBSortedLargeCollectionElement::DBSortedLargeCollectionElement (const DBSortedLargeCollectionElement& op)

 : LSCollectionElementsObj ( op )
{
	
}

DBSortedLargeCollectionElement::DBSortedLargeCollectionElement ()

{
	
}

CollectionNodeObj& CollectionNodeObj::operator = (const CollectionNodeObj& op)
{
	StoreObj :: operator=( (RStoreObj) op );
	if ( GetDba() != 0 )
	{
		CrSet ();
		Read ();
	}
	return *this;
}

DBCollectionNode& DBCollectionNode::operator = (const DBCollectionNode& op)
{
	CollectionNodeObj::operator= ( op );
	return *this;
}

DBElementBase* DBSortedSmallCollectionElement::CloneElement ()
{
	return 
		new DBSortedSmallCollectionElement (*this);
}

DBElementBase* DBSmallCollectionElement::CloneElement ()
{
	return 
		new DBSmallCollectionElement (*this);
}

DBElementBase* DBLargeCollectionElement::CloneElement ()
{
	return 
		new DBLargeCollectionElement (*this);
}

DBElementBase* DBSortedLargeCollectionElement::CloneElement ()
{
	return 
		new DBSortedLargeCollectionElement (*this);
}

CollectionNodeObj::CollectionNodeObj (const CollectionNodeObj& o)

 : StoreObj ((RStoreObj)o)
{
	if ( GetDba() != 0 )
	{
		CrSet ();
		Read ();
	}
}

