//. MODULE: AppCollections source

// @@DatatypeInclude
#ifndef INC_GLOBAL_HPP
#include "global.hpp"
#endif
// @@End
// @@Includes
#ifndef INC_APPCOLLE_HPP
#include "appcolle.hpp"
#endif
// @@End
#ifndef INC_DBAPPOBJ_HPP
#include "dbappobj.hpp"
#endif
#ifndef INC_OBJECTS_HPP
#include "objects.hpp"
#endif
DBPlanillaIdCollection::DBPlanillaIdCollection ()

 : DBSortedCollection ( cidPlanillaId, 80 )
{
	InsertAll () ;
	Init () ;   // set count and make first element current
}

void DBPlanillaIdCollection::InsertAll ()
{
		TDate :: HowToPrint prnDefault = TDate :: SetPrintOption ( TDate :: Normal ) ;
		
		char data [ 81 ], keybuf [ 81 ] ;
		KeyFechaPlan	keyPlan ;
		
		Planilla planilla ( keyPlan ) ;
		Compania compania ;
		Proyecto proyecto ;
			
		planilla[ FIRST ] ;
		while ( planilla.Okay () )
		{
			planilla << proyecto << compania ;
		
			ostrstream osd ( data, sizeof data ) ;
			osd.setf(ios::left, ios::adjustfield) ;
			osd << setw ( 19 ) << planilla.GetFechaPlanilla () << "\t" ;
			osd << setw ( 30 ) << compania.GetNombre () << "\t" ;
			osd << proyecto.GetId () << ends ;
	
			TDate date = planilla.GetFechaPlanilla () ;
	
			ostrstream osk ( keybuf, sizeof keybuf ) ;
			osk.fill ( '0' ) ;
			osk << setw ( 2 ) << (date.Year () % 100) << setw ( 2 ) << date.Month () << setw ( 2 ) << date.DayOfMonth() ;
			osk << setw ( 30 ) << compania.GetNombre () << ends ;
		
			Insert ( planilla.GetDba (), osd.str(), osk.str() ) ;
			planilla++;
		}
		TDate :: SetPrintOption ( prnDefault ) ;
}

void DBCompaniaCollection::InsertAll ()
{
	char data [ 81 ] ;
	
	KeyNombreCompania	keyComp ;
	Compania compania ( keyComp ) ;
	
	compania [ FIRST ] ;
	while ( compania.Okay () )
	{
		ostrstream osd ( data, sizeof data ) ;
		osd << compania.GetNombre () << ends ;
	
		Insert ( compania.GetDba (), osd.str() ) ;
		compania++;
	}
}

DBCompaniaCollection::DBCompaniaCollection ()

 : DBUnsortedCollection ( cidCompania, 80 )
{
	InsertAll () ;
	Init () ;   // set count and make first element current
}

DBProyectosDeCompania::DBProyectosDeCompania (DB_ADDR dba)

 : DBUnsortedCollection ( cidProyectosDeCompania, 80 )
{
	Compania compania ;
	compania [ DbAddr ( dba ) ] ;
	if ( compania.Okay () )
	{
		InsertAll ( compania ) ;
		Init () ;   // set count and make first element current
	}
}

void DBProyectosDeCompania::InsertAll (Compania& compania)
{
	char data [ 81 ] ;
	Proyecto& proy = compania.GetProyectos ().Current() ;
	while ( proy.Okay () )
	{
		ostrstream osd ( data, sizeof data ) ;
		osd << proy.GetNombre () << ends ;
	
		Insert ( proy.GetDba (), osd.str() ) ;
		proy++;
	}
}

DBProyectosDeCompania::DBProyectosDeCompania (Compania& compania)

 : DBUnsortedCollection ( cidProyectosDeCompania, 80 )
{
	if ( compania.Okay () )
	{
		InsertAll ( compania ) ;
		Init () ;   // set count and make first element current
	}
}

DBNacionalidades::DBNacionalidades ()

 : DBSortedCollection ( cidNacionalidades, 80 )
{
	InsertAll () ;
	Init () ;   // set count and make first element current
}

void DBNacionalidades::InsertAll ()
{
		char data [ 81 ], keybuf [ 81 ] ;
		KeyNacionalidad keyNacionalidad;
		
		Pais pais ( keyNacionalidad ) ;
	
		pais[ FIRST ] ;
		while ( pais.Okay () )
		{
			ostrstream osd ( data, sizeof data ) ;
			osd.setf(ios::left, ios::adjustfield) ;
			osd << pais.GetNacionalidad() << ends ;
	
			ostrstream osk ( keybuf, sizeof keybuf ) ;
			osk << pais.GetNacionalidad() << ends ;
		
			Insert ( pais.GetDba (), osd.str(), osk.str() ) ;
			pais++;
		}
}

DBEmpleadoIdCollection::DBEmpleadoIdCollection ()

 : DBUnsortedCollection ( cidEmpleados, 80 )
{
	InsertAll () ;
	Init () ;   // set count and make first element current
}

void DBEmpleadoIdCollection::InsertAll ()
{
		char data [ 81 ] ;
		KeyNombreEmpleado keyNombre ;
		
		Empleado empleado ( keyNombre ) ;
	
		empleado[ FIRST ] ;
		while ( empleado.Okay () )
		{
			ostrstream osd ( data, sizeof data ) ;
			osd.setf(ios::left, ios::adjustfield) ;
			osd << setw ( 20 ) << empleado.GetApellidos() << "\t" ;
			osd << setw ( 20 ) << empleado.GetNombre () << "\t" ;
			osd << empleado.GetFullId () << ends ;
	
			Insert ( empleado.GetDba (), osd.str() ) ;
			empleado++;
		}
}

