#ifndef INC_TVLISTBO_HPP
#define INC_TVLISTBO_HPP

//. MODULE: TVListBox header

// @@DatatypeInclude
#ifndef INC_GLOBAL_HPP
#include "global.hpp"
#endif
// @@End
// @@Includes
#ifndef INC_GLOBAL_HPP
#include "global.hpp"
#endif
// @@End
#ifndef INC_VLISTINT_H
#include "vlistint.h"
#endif
#ifndef INC_DBCOLLEC_HPP
#include "dbcollec.hpp"
#endif
class TVListBox : public TControl

{
	public:
		enum constantes
		{
			DisplayWidth = 256
		};
		TVListBox (TWindow* parent, int id, int x, int y, int w, int h, TModule* module = 0);
		TVListBox (TWindow* parent, int resourceId, TModule* module = 0);
		//. list box attributes
	private:
		TVListBox (const TVListBox& rTvListBox);
	public:
		virtual void ClearList ();
		virtual long FindString (const char far* find, long indexStart) const;
		virtual long VlbGetCount () const;
		int GetHorizontalExtent () const;
		virtual DWORD GetItemData (long index) const;
		virtual int GetItemHeight () const;
		int GetItemRect (long index, TRect& rect) const;
		virtual long GetSelIndex () const;
		int GetSelString (char far* str, int maxChars) const;
		virtual int GetString (char far* str, long index) const;
		//. returns the string's length !
	protected:
		virtual void SetupWindow ();
		PVLBOX pVLBox;
	public:
		virtual int GetStringLen (long index) const;
		long GetTopIndex () const;
	private:
		TVListBox & operator = (const TVListBox&);
	public:
		void SetHorizontalExtent (int horzExtent);
		virtual int SetItemData (long index, DWORD itemData);
		virtual int SetItemHeight (int height);
		//. operations on the list box itself
		virtual int SetSelIndex (int setOption, long index);
		//. setOption can be one of:
		//. VLB_FIRST
		//. VLB_PREV
		//. VLB_NEXT
		//. VLB_LAST
		//. VLB_FINDITEM.
		long SetSelString (const char far* find, long indexStart);
		//. multiple selection list boxes only
		BOOL SetTabStops (int numTabs, int far* tabs);
		int SetTopIndex (long index);
		UINT Transfer (void *buffer, TTransferDirection direction);
		//. Override TWindow virtual member functions
	protected:
		char far * GetClassName ();
		//. hidden to prevent accidental copying or assignment
	public:
		virtual void NewList (DBAbstractCollection* aList);
	private:
		DBAbstractCollection* items;
		//. database collection (DBSmallCollection)
	public:
		void SetTextPointer (LPVLBSTRUCT lpVLB);
	protected:
		static char szText [TVListBox::DisplayWidth];
	public:
		VirtualRecordId Get () const;
		//. high level getData ()
		long GetCount ();
		virtual inline int SetSelIndex (long index);
		//. Calls more general SetSelIndex
		//. with setOption == VLB_FINDITEM
		virtual ~TVListBox ();
		//. list box attributes
		//. returns the string's length !
		//. operations on the list box itself
		//. setOption can be one of:
		//. VLB_FIRST
		//. VLB_PREV
		//. VLB_NEXT
		//. VLB_LAST
		//. VLB_FINDITEM.
		//. multiple selection list boxes only
		//. Override TWindow virtual member functions
	protected:
		//. hidden to prevent accidental copying or assignment
	private:
		//. database collection (DBSmallCollection)
	public:
		//. high level getData ()
		//. Calls more general SetSelIndex
		//. with setOption == VLB_FINDITEM
};

struct TVListBoxData

{
	protected:
		DBAbstractCollection* items;
		long focused;
	public:
		TVListBoxData ();
		~TVListBoxData ();
		VirtualRecordId GetVirtualRecordId ();
		inline void SetItems (DBAbstractCollection* it);
		inline void SetFocused (long f);
		inline long GetFocused () const;
		inline DBAbstractCollection * GetItems () const;
		BOOL Select (VirtualRecordId id);
		const char* GetString ();
};

inline int TVListBox::SetSelIndex (long index)
{
	return SetSelIndex ( VLB_FINDITEM, index );
}

inline void TVListBoxData::SetItems (DBAbstractCollection* it)//: using reference counting in
	//. DBAbstractCollection !
{
	if ( items == 0 )
	{
		if ( it != 0 )
		{
			//	call copy constructor
			items = it->Clone ();
			focused = -1 ;
		}
	}
	else	//	items != 0
	{
		if ( it != 0 && ((*items) != (*it)) )
		{
			//	assignment operator
			( *items ) = (*it);
			focused = -1 ;
		}
	}
	if ( it == 0 )
	{
		delete items ;
		items = 0 ;
		focused = -1 ;
	}
	/*	this worked ...
	if ( items != it )
	{
		items = it ;
		focused = -1 ;
	}
	*/
}

inline void TVListBoxData::SetFocused (long f)
{
	focused = f ;
}

inline long TVListBoxData::GetFocused () const 
{
	return focused ;
}

inline DBAbstractCollection * TVListBoxData::GetItems () const 
{
	return items ;
}


#endif
