// edit.cpp			BROWSE RECORD EDIT WINDOW
//	written by Gregory K. Miskin
//	COPYRIGHT (C) 1992.  All Rights Reserved.
//	Gregory K. Miskin, Orem, Utah  USA

#define Uses_TButton
#define Uses_TEvent
#define Uses_TDialog
#define Uses_TRect
#define Uses_TLabel
#define Uses_TInputLine
#define Uses_TCheckBoxes
#define Uses_TSItem
#define Uses_MsgBox

#include <tv.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include "commands.hpp"
#include "formatln.hpp"
#include "edit.hpp"

struct date 	DATE;
long recs;

/*------------------------------------------------------------------------*/
TEditRecord::TEditRecord(DataIndex **i) :
		TDialog(TRect(0, 0, 67, 20), "Edit Names"),
		TWindowInit(&TEditRecord::initFrame)
{
	SetupScreen();
	name 	= i;
	int col1, col2, col3, col4, lin1, lin2;
	col1 = 52;
	col2 = 65;
	col3 = col1 - 5;
	col4 = col2 - 5;
	lin1 = 2;
	lin2 = lin1 + 2;

	e_del1 	= new TButton(TRect(col1, lin1, col2, lin2), "Delete ~1~", cmDelete,  bfNormal);
	lin1 += 2;
	lin2 += 2;

	e_undel1	= new TButton(TRect(col1, lin1, col2, lin2), "Restore ~2~", cmRestore,  bfNormal);
	lin1 += 3;
	lin2 += 3;

	e_save 	= new TButton(TRect(col3, lin1, col4, lin2), "~S~ave",   cmSave, 	  bfNormal);
	lin1 += 2;
	lin2 += 2;

	e_quit 	= new TButton(TRect(col3, lin1, col4, lin2), "~Q~uit",   cmCancel,  bfNormal);
	lin1 += 3;
	lin2 += 3;

	e_compare= new TButton(TRect(col1, lin1, col2, lin2), "~C~ompare",   cmCompare,  bfNormal);
	lin1 += 3;
	lin2 += 3;

	e_del2 	= new TButton(TRect(col1, lin1, col2, lin2), "Delete ~3~", cmDelete2,  bfNormal);
	lin1 += 2;
	lin2 += 2;

	e_undel2	= new TButton(TRect(col1, lin1, col2, lin2), "Restore ~4~", cmRestore2,  bfNormal);
	lin1 += 3;
	lin2 += 3;

	insert(e_del1);
	insert(e_undel1);
	insert(e_save);
	insert(e_quit);
	insert(e_compare);
	insert(e_del2);
	insert(e_undel2);

	Initialize();
}

/*------------------------------------------------------------------------*/
void TEditRecord::SetupScreen()
{
	int col1, col2, col3, col4, lin1, lin2, len, start;
	col1 = 14;
	col2 = 0;
	lin1 = 2;
	start = lin1;
	lin2 = lin1 + 1;

	/*----------------- these are the fields of the initial record --------*/
	len = 16;
	col2 = col1 + (len + 2);
	e_fname  = new TFormatLine(TRect(col1, lin1, col2, lin2),"AAAAAAAAAAAAAAA",len);

	len = 7;
	e_count  = new TFormatLine(TRect(41, lin1, 51, lin2),"NNNNNN",len);

	lin1++;
	lin2++;
	len = 16;
	col2 = col1 + (len + 2);
	e_lname  = new TFormatLine(TRect(col1, lin1, col2, lin2),
						"AAAAAAAAAAAAAAA",len);

	len = 7;
	col2 = col1 + (len + 2);
	e_recno  = new TFormatLine(TRect(41, lin1, 51, lin2),"NNNNNN",len);

	lin1++;
	lin2++;
	len = 31;
	col2 = col1 + (len + 2);
	e_street = new TFormatLine(TRect(col1, lin1, col2, lin2),
						"UUUUUUUUUUUUUUUUUUUUUUUUUUUUUU",len);

	lin1++;
	lin2++;
	len = 21;
	col2 = col1 + (len + 2);
	e_city   = new TFormatLine(TRect(col1, lin1, col2, lin2),
						"AAAAAAAAAAAAAAAAAAAA",len);

	lin1++;
	lin2++;
	len = 3;
	col2 = col1 + (len + 2);
	e_state  = new TFormatLine(TRect(col1, lin1, col2, lin2),"AA",len);

	lin1++;
	lin2++;
	len = 6;
	col2 = col1 + (len + 2);
	e_zip    = new TFormatLine(TRect(col1, lin1, col2, lin2),"NNNNN",len);

	lin1 = start;
	lin2 = lin1 + 1;
	col3 = 1;
	col4 = 13;

	insert(e_fname);
	insert(new TLabel(TRect(col3, lin1, col4, lin2),  "First Name:", e_fname));

	e_count->options &= (!ofSelectable);
	insert(e_count);
	insert(new TStaticText(TRect(34,lin1,41,lin2), "Count:"));

	lin1++;
	lin2++;
	insert(e_lname);
	insert(new TLabel(TRect(col3, lin1, col4, lin2),  " Last Name:", e_lname));

	e_recno->options &= (!ofSelectable);
	insert(e_recno);
	insert(new TStaticText(TRect(34,lin1,41,lin2), "RecNo:"));

	lin1++;
	lin2++;
	insert(e_street);
	insert(new TLabel(TRect(col3, lin1, col4, lin2),  "    Street:", e_street));

	lin1++;
	lin2++;
	insert(e_city);
	insert(new TLabel(TRect(col3, lin1, col4, lin2),  "      City:", e_city));

	lin1++;
	lin2++;
	insert(e_state);
	insert(new TLabel(TRect(col3, lin1, col4, lin2),  "     State:", e_state));

	lin1++;
	lin2++;
	insert(e_zip);
	insert(new TLabel(TRect(col3, lin1, col4, lin2),  "       Zip:", e_zip));

	/*----------- these are the fields of the comparison record -----------*/
	lin1+= 5;
	lin2+= 5;
	int comp = lin1;
	len = 16;
	col2 = col1 + (len + 2);
	c_fname  = new TFormatLine(TRect(col1, lin1, col2, lin2),"AAAAAAAAAAAAAAA",len);

	len = 7;
	c_recno  = new TFormatLine(TRect(41, lin1, 51, lin2),"NNNNNN",len);

	lin1++;
	lin2++;
	len = 16;
	col2 = col1 + (len + 2);
	c_lname  = new TFormatLine(TRect(col1, lin1, col2, lin2),
						"AAAAAAAAAAAAAAA",len);

	lin1++;
	lin2++;
	len = 31;
	col2 = col1 + (len + 2);
	c_street = new TFormatLine(TRect(col1, lin1, col2, lin2),
						"UUUUUUUUUUUUUUUUUUUUUUUUUUUUUU",len);

	lin1++;
	lin2++;
	len = 21;
	col2 = col1 + (len + 2);
	c_city   = new TFormatLine(TRect(col1, lin1, col2, lin2),
						"AAAAAAAAAAAAAAAAAAAA",len);

	lin1++;
	lin2++;
	len = 3;
	col2 = col1 + (len + 2);
	c_state  = new TFormatLine(TRect(col1, lin1, col2, lin2),"AA",len);

	lin1++;
	lin2++;
	len = 6;
	col2 = col1 + (len + 2);
	c_zip    = new TFormatLine(TRect(col1, lin1, col2, lin2),"NNNNN",len);

	lin1 = comp;
	lin2 = lin1 +1;
	insert(c_fname);
	insert(new TLabel(TRect(col3, lin1, col4, lin2),  "First Name:", c_fname));

	insert(c_recno);
	insert(new TLabel(TRect(34,lin1,41,lin2), "~R~ecNo:", c_recno));

	lin1++;
	lin2++;
	insert(c_lname);
	insert(new TLabel(TRect(col3, lin1, col4, lin2),  " Last Name:", c_lname));

	lin1++;
	lin2++;
	insert(c_street);
	insert(new TLabel(TRect(col3, lin1, col4, lin2),  "    Street:", c_street));

	lin1++;
	lin2++;
	insert(c_city);
	insert(new TLabel(TRect(col3, lin1, col4, lin2),  "      City:", c_city));

	lin1++;
	lin2++;
	insert(c_state);
	insert(new TLabel(TRect(col3, lin1, col4, lin2),  "     State:", c_state));

	lin1++;
	lin2++;
	insert(c_zip);
	insert(new TLabel(TRect(col3, lin1, col4, lin2),  "       Zip:", c_zip));
}

/*------------------------------------------------------------------------*/
void TEditRecord::Initialize()
{
	int stat;
	delCount = 0;

	options |= ofCentered;
	selectNext(FALSE);
	memset(&fields, 0, sizeof(fields));
	recs = (*name)->reccount();
	itoa(recs, fields.count, 10);
	itoa((*name)->recno(), fields.recno, 10);
	getdate(&DATE);
	GetBaseFields();
	setData(&fields);
	baseRec = (*name)->recno();
}

/*------------------------------------------------------------------------*/
void TEditRecord::handleEvent(TEvent &event)
{
	 TDialog::handleEvent(event);

	 switch(event.what)
	 {
		case evCommand:
			switch(event.message.command)
			{
				case cmSave:
					// save changes to database
					SaveFile();
					break;

				case cmDelete:
					// delete current record
					Delete();
					break;

				case cmRestore:
					// delete current record
					UnDelete();
					break;

				case cmCompare:
					// get record for comparison
					GetCompareRec();
					break;

				case cmDelete2:
					// delete current record
					Delete2();
					break;

				case cmRestore2:
					// delete current record
					UnDelete2();
					break;

				default:
					break;
			}
			break;

		case evBroadcast:
			if(event.message.command == cmDefault)
			{
				if(current == c_recno)
					GetCompareRec();

				selectNext(FALSE);
			}
			break;

		case evKeyDown:
			switch(event.keyDown.keyCode)
			{

				case kbDown:
					selectNext(FALSE);
					break;

				case kbUp:
					selectNext(TRUE);
					break;

				default:
					break;
			}
			break;

		default:
			return;
	}
}

/*------------------------------------------------------------------------*/
TEditRecord::~TEditRecord(void)
{
	long currRec = (*name)->recno();

	if(currRec == compRec)
		(*name)->go(baseRec);

}

/*------------------------------------------------------------------------*/
void TEditRecord::Cancel(TEvent &event)
{
	event.what = evCommand;
	event.message.command = cmCancel;
	event.message.infoPtr = 0;
	putEvent(event);
}

/*------------------------------------------------------------------------*/
void TEditRecord::GetCompareRec()
{
	getData(&fields);
	compRec = atol(fields.recno_c);

	if(compRec > NULL)
	{
		(*name)->go(compRec);
		GetCompFields();
		setData(&fields);
	}
	else
	{
		messageBox("\003No record number for comparision",
			mfError | mfOKButton);
		setCurrent(c_recno, normalSelect);
	}
}

/*------------------------------------------------------------------------*/
void TEditRecord::SaveFile()
{
	long currRec = (*name)->recno();
	getData(&fields);

	if(currRec == compRec)
	{
		SaveRecord2();
		(*name)->go(baseRec);
		SaveRecord1();
	}
	else
		if(currRec == baseRec)
		{
			SaveRecord1();
			if(compRec > NULL)
			{
				(*name)->go(compRec);
				SaveRecord2();
			}
		}
}

/*------------------------------------------------------------------------*/
void TEditRecord::SaveRecord1()
{
	WriteRecord1();
	(*name)->flush_record();
}

/*------------------------------------------------------------------------*/
void TEditRecord::SaveRecord2()
{
	WriteRecord2();
	(*name)->flush_record();
}

/*------------------------------------------------------------------------*/
void TEditRecord::Delete(void)
{
	long currRec = (*name)->recno();

	if(currRec == compRec)
		(*name)->go(baseRec);

	if(!(*name)->deleted())
	{
		(*name)->delete_rec();
		delCount++;
		messageBox("\003Record 1 flagged for deletion",
			mfInformation | mfOKButton);
	}
	else
		messageBox("\003Record 1 already deleted",
			mfError | mfOKButton);
}

/*------------------------------------------------------------------------*/
void TEditRecord::Delete2(void)
{
	if(compRec > NULL)
	{
		long currRec = (*name)->recno();

		if(currRec == baseRec)
			(*name)->go(compRec);

		if(!(*name)->deleted())
		{
			(*name)->delete_rec();
			delCount++;
			messageBox("\003Record 2 flagged for deletion",
				mfInformation | mfOKButton);
		}
		else
			messageBox("\003Record 2 already deleted",
				mfError | mfOKButton);
	}
	else
		messageBox("\003Record 2 not specified",
			mfError | mfOKButton);
}

/*------------------------------------------------------------------------*/
void TEditRecord::UnDelete(void)
{
	long currRec = (*name)->recno();

	if(currRec == compRec)
		(*name)->go(baseRec);

	if((*name)->deleted())
	{
		(*name)->recall();
		delCount--;
		messageBox("\003Delete flag removed from record 1",
			mfInformation | mfOKButton);
	}
	else
		messageBox("\003Record 1 not deleted",
			mfError | mfOKButton);
}

/*------------------------------------------------------------------------*/
void TEditRecord::UnDelete2(void)
{
	if(compRec > NULL)
	{
		long currRec = (*name)->recno();

		if(currRec == baseRec)
			(*name)->go(compRec);

		if((*name)->deleted())
		{
			(*name)->recall();
			delCount--;
			messageBox("\003Delete flag removed from record 2",
				mfInformation | mfOKButton);
		}
		else
			messageBox("\003Record 2 not deleted",
				mfError | mfOKButton);
	}
	else
		messageBox("\003Record 2 not specified",
			mfError | mfOKButton);
}

/*------------------------------------------------------------------------*/
void TEditRecord::GetStr(int field_num, char *fld)
{
	int len = 0;

	Fld = (*name)->field(field_num);
	len = Fld->len();
	strncpy(fld,Fld->ptr(),len);
}

/*------------------------------------------------------------------------*/
void TEditRecord::PutStr(int field_num, char *fld)
{
	Fld = (*name)->field(field_num);
	*Fld = fld;
}

/*------------------------------------------------------------------------*/
void TEditRecord::GetBaseFields(void)
{
	GetStr(nmFIRST_NAME, fields.fname);
	GetStr(nmLAST_NAME, 	fields.lname);
	GetStr(nmSTREET, 		fields.street);
	GetStr(nmCITY, 		fields.city);
	GetStr(nmSTATE, 		fields.state);
	GetStr(nmZIP, 			fields.zip);
}

/*------------------------------------------------------------------------*/
void TEditRecord::GetCompFields(void)
{
	GetStr(nmFIRST_NAME, fields.fname_c);
	GetStr(nmLAST_NAME, 	fields.lname_c);
	GetStr(nmSTREET, 		fields.street_c);
	GetStr(nmCITY, 		fields.city_c);
	GetStr(nmSTATE, 		fields.state_c);
	GetStr(nmZIP, 			fields.zip_c);
}

/*------------------------------------------------------------------------*/
void TEditRecord::WriteRecord1(void)
{
	PutStr(nmFIRST_NAME, fields.fname);
	PutStr(nmLAST_NAME,  fields.lname);
	PutStr(nmSTREET,     fields.street);
	PutStr(nmCITY,       fields.city);
	PutStr(nmSTATE,      fields.state);
	PutStr(nmZIP,        fields.zip);
}

/*------------------------------------------------------------------------*/
void TEditRecord::WriteRecord2(void)
{
	PutStr(nmFIRST_NAME, fields.fname_c);
	PutStr(nmLAST_NAME,  fields.lname_c);
	PutStr(nmSTREET,     fields.street_c);
	PutStr(nmCITY,       fields.city_c);
	PutStr(nmSTATE,      fields.state_c);
	PutStr(nmZIP,        fields.zip_c);
}
