/*-------------------------------[ Vlib ]------------------------------*/
/*                      Text File Viewer Library                       */
/*---------------------------------------------------------------------*/
/* Written by: Jeff Dunlop                                             */
/* Copyright 1991 DB/Soft Publishing Co. All Rights Reserved           */
/*---------------------------------------------------------------------*/

/*-------------------------------[ vlib.h ]----------------------------*/
/*             Main header file for VLib file view library             */
/*---------------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/*---------------------------[ defines ]------------------------*/
/*--------------------------------------------------------------*/

#ifndef vlib_h
#   define vlib_h

#define TRUE 1
#define FALSE 0

#define VLIB_ARGERR   1
#define VLIB_DOSERR   2
#define VLIB_ALLOCERR 3

#define BLACK           0
#define BLUE            1
#define GREEN           2
#define CYAN            3
#define RED             4
#define MAGENTA         5
#define BROWN           6
#define LIGHTGREY       7
#define DARKGREY        8
#define LIGHTBLUE       9
#define LIGHTGREEN      10
#define LIGHTCYAN       11
#define LIGHTRED        12
#define LIGHTMAGENTA    13
#define YELLOW          14
#define WHITE           15

/*--------------------------------------------------------------*/
/*-------------------------[ structures ]-----------------------*/
/*--------------------------------------------------------------*/

typedef struct
{
    int b_enable;               /* must be 1 to display border          */
    char b_string[8];           /* Ŀ is a typical example         */
    char Foreground;
    char Background;            /* the attribute for the border         */
    char attr;
} BORDER;

/*--------------------------------------------------------------*/
/*--------------------[ function prototypes ]-------------------*/
/*--------------------------------------------------------------*/

int vlLister(char *file_spec, int x1, int y1, int x2, int y2,
           unsigned char Foreground, unsigned char Background,
           unsigned buf_size, BORDER *border_info);

int vlGetCols(void);
int vlGetRows(void);
int vlIsDV(void);
int vlIsEgaVga(void);
int vlIsLshift(void);
int vlIsMono(void);
int vlIsRshift(void);
int vlIsShift(void);
unsigned char vlGetVidMode(void);
unsigned vlGetVidbase(void);

#endif /* ifdef vlib_h */
