{ * * * * comtst.pas * * * * }

{$X+}  { enable c-like extensions }

program comtst;

   uses
      strings,
      wincrt,
      wintypes, winprocs;

   var
      dev_ctl : tdcb;

function comopen( var dev_ctl : tdcb; mode : pchar) : boolean;
   { ***
   --- SET UP SERIAL PORT DEVICE CONTROL ---
   *** }

   var
      com_name : array[ 0..7 ] of char;
      com_hdl  : integer;

begin
   comopen := false;
   strmove( com_name, mode, 4);  { 'comx' }
   com_name[ 4 ] := #0;
   com_hdl := opencomm( com_name, 4000, 4000);
   if ( com_hdl >= 0) then
   begin
      if ( buildcommdcb( mode, dev_ctl) >= 0) then
      begin
         dev_ctl.id := com_hdl;
         if ( setcommstate( dev_ctl) >= 0) then
         begin
            comopen := true;
         end;  { initialized port? }
      end;  { set up port parameters? }
   end;  { opened port? }
end;
{ comopen() _______________________________________________________ }

procedure comclose( var dev_ctl : tdcb);
   { ***
   --- SHUT DOWN SERIAL PORT DEVICE ---
   *** }
begin
   closecomm( dev_ctl.id);
end;
{ comclose() ______________________________________________________ }

function computs( var dev_ctl : tdcb; var msg : string) : boolean;
   { ***
   --- OUTPUT A MESSAGE TO THE SERIAL PORT ---
   *** }

   var
      err : integer;

begin
   err :=  writecomm( dev_ctl.id, @msg[ 1 ], integer( msg[ 0 ]) );
   computs := ( err >= 0);  { negative value indicates error }
end;
{ computs() _______________________________________________________ }

procedure echo( var dev_ctl : tdcb);
   { ***
   --- ECHO BACK INPUT FROM SERIAL PORT ---
   *** }

   const
      sign_on      : string =
            'Welcome to the bogus windows system' + #13;
      instructions : string =
            'Press Q or Esc to quit...' + #13;

   var
      c   : char;
      cnt : integer;

begin
   computs( dev_ctl, sign_on);
   computs( dev_ctl, instructions);

{ $ IFDEF DEADCODE }
   c := #0;
   while ( not ( c in [ 'Q', 'q', #27 ]) ) do

   begin
      yield;
      cnt := readcomm( dev_ctl.id, @c, 1);
      { cnt := 1; }
      { c := readkey; }
      if ( cnt > 0) then
      begin
         write( c);
         yield;
         writecomm( dev_ctl.id, @c, 1);
      end  { character received? }
      else if ( cnt < 0) then
      begin
         writeln;
         writeln( 'readcomm error code:  ', cnt);
      end;  { error code? }
   end;  { read & echo until user quits }
{ $ ENDIF }

end;
{ echo() __________________________________________________________ }

begin
   writeln( 'Attempting to open communications...');
   if ( not comopen( dev_ctl, 'COM1:9600,N,8,1') ) then
   begin
      writeln( 'Failed opening communications');
      halt;
   end;  { opened com port? }

   writeln( 'Attempting to transmit/receive...');
   echo( dev_ctl);

   writeln( 'Closing communications');
   comclose( dev_ctl);
end.
{ "main" __________________________________________________________ }


{ ***************** EOF: COMTST.PAS ********************** }
