// Vect2.h, By Scott Litvinoff
// Class definition for 2-d vectors
// All angles are relative to east, with positive angles being in the northern
// direction and negative angles being in the southern direction

#include "stdlib.h"
#include "float.h"
#include "iostream.h"
#include "math.h"

#define Polar '1'
#define Rect '2'

class vector2
{
    double mag,ang,x,y;

    public:
    vector2(char inrad='0',char type='1',double part1=0,double part2=0)
    {
        double dummy1,dummy2,dummy3;   //Constructor
        if(type==Polar)                //Vector can be constructed in rectangular
        {                              //or polar form, whenever constructing a
            mag=part1;                 //vector in polar form, if the vector's
            dummy1=fmod(((part2 * 2 * M_PI) / 360) , (2 * M_PI));
            if(inrad=='0')             //angle is in degrees then set the first
            {                          //parameter to '0', if it's in radians
                dummy2=cos(dummy1)*mag; //set it to '1',the angle is stored in
                dummy3=sin(dummy1)*mag; //radians, the second parameter should
            }                          //be either Polar if it's polar, or
            else                       //Rect if it's rectangular
            {                          //If polar, part1 is magnitude and
                dummy2=cos(part2)*mag; //part2 is angle, if rectangular, part1
                dummy3=sin(part2)*mag; //is x and part2 is y
            }
            x=dummy2;                  //Vector is stored in both forms internally
            y=dummy3;
            if(inrad=='1')
            ang=part2;
            else
            ang=dummy1;
            return;
        }
        if(type==Rect)
        {
            x=part1;
            y=part2;
            if(x>0)
            dummy1=atan(part2/part1);
            else
            dummy1=M_PI/2;
            dummy2=sqrt((part1*part1)+(part2*part2));
            ang=dummy1;
            mag=dummy2;
            return;
        }
    }
    friend vector2 operator+(vector2&,vector2&);   // Vector binary addition

    friend vector2 operator*(vector2&,vector2&);   // Vector binary multiplication

    friend vector2 operator/(vector2&,vector2&);   // Vector binary division

    friend vector2 operator-(vector2&,vector2&);   // Vector binary subtraction

    friend vector2 operator-(vector2&);           // Unary vector negation

    friend vector2 operator*(vector2&,double);    // Scalar multiplication of vector

    friend vector2 operator*(double,vector2&);    // Scalar multiplication of vector

    friend double operator|(vector2&,vector2&);   // Vector dot product

    void print(char which)           //Outputs vector in either form
    {                                //If which is set to Rect then outputs
        double dummy;                //In rectangular form, if Polar, then
        if(which==Rect)              //Outputs in polar, if in polar, outputs
        {                            //angle in degrees
            if(x < 1e-4)
            cout<<'0';
            else
            cout<<x;
            cout<<",";
            if(y < 1e-4)
            cout<<'0';
            else
            cout<<y;
            return;
        }
        if(which==Polar)
        {
            dummy=fmod(((360 * ang) / (2 * M_PI)) , 360);
            if(mag < 1e-4)
            cout<<'0';
            else
            cout<<mag;
            cout<<",";
            if(dummy < 1e-4)
            cout<<'0';
            else
            cout<<dummy;
            cout<<"";
            return;
        }
        return;
    }
    double xp(vector2 &__dude)
    {
        return(__dude.x);             //Returns x coordinate of vector
    }
    double yp(vector2 &__dude)
    {
        return(__dude.y);             //Returns y coordinate of vector
    }
    double magp(vector2 &__dude)
    {
        return(__dude.mag);           //Returns magnitude of vector
    }
    double angr(vector2 &__dude)
    {
        return(__dude.ang);           //Returns angle of vector in radians
    }
    double angd(vector2 &__dude)
    {
        double dummy;                 //Returns angle of vector in degrees
        dummy=fmod(((360 * __dude.ang) / (2 * M_PI)) , 360);
        return(dummy);
    }
};
