#include  <windows.h>
#include  <bivbx.h>
#define VBXGEN_DATA
#include  "vbxwin.rh"
// ======================================================== //
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

// ======================================================== //
HINSTANCE hInst;
int result;
HFORMFILE file;
HCTL hCtl;

// ======================================================== //
#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,
			LPSTR lpCmdLine,  int nCmdShow )
{
	 static char szAppName[]  = "VBX Window Program";

	 HWND     hwnd;
	 MSG      msg;
	 WNDCLASS wndclass;

	 hInst = hInstance;

	 if( !hPrevInstance )
	 {
		 wndclass.style = CS_HREDRAW | CS_VREDRAW;
		 wndclass.lpfnWndProc   = WndProc;
		 wndclass.cbClsExtra    = 0;
		 wndclass.cbWndExtra    = 0;
		 wndclass.hInstance     = hInstance;
		 wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
		 wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW );
		 wndclass.hbrBackground = (HBRUSH)GetStockObject
										  ( WHITE_BRUSH );
		 wndclass.lpszMenuName  = MAKEINTRESOURCE(MENU_1);
		 wndclass.lpszClassName = szAppName;

		 RegisterClass( &wndclass );
	 }
	 //  (1)  Initialize VB emulator
	 result = VBXInit( hInst, "Thunder" );
	 //  (2)  Create a form file for the control
	 file = VBXCreateFormFile(sizeof(SpreadSheetData), SpreadSheetData);

	 hwnd = CreateWindow( szAppName, "Simple VBX Program",
						  WS_OVERLAPPEDWINDOW,
						  CW_USEDEFAULT, CW_USEDEFAULT,
						  CW_USEDEFAULT, CW_USEDEFAULT,
						  NULL, NULL, hInst, NULL );
	 ShowWindow( hwnd, nCmdShow );
	 UpdateWindow( hwnd );


	 while( GetMessage( &msg, NULL, 0, 0 ) )
	 {
		 TranslateMessage(&msg);
		 DispatchMessage(&msg);
	 }

	 VBXDeleteFormFile( file );
	 VBXTerm();
	 return msg.wParam;
}

LRESULT CALLBACK WndProc( HWND hwnd, UINT msg,
						  WPARAM wParam, LPARAM lParam )
{
  int result;

  switch( msg )
  {
	 case WM_COMMAND:
	 {
		switch( wParam )
		{
		  case CM_FILETEST:
		  {
			 RECT rect;
			 HMENU hMenu;
			 GetClientRect( hwnd, &rect );
			 // (3) create the control as a child of the main window
			 hCtl = VBXCreate(hwnd, IDC_SPREAD1, "ssbc.vbx", "SpreadSheet",
											 "", WS_CHILD, rect.left, rect.top,
											 rect.right, rect.bottom, file );
			 hMenu = GetMenu( hwnd );
			 EnableMenuItem( hMenu, CM_FILETEST, MF_GRAYED );
			 break;
		  }
		  case CM_FILEEXIT:
			PostMessage( hwnd, WM_CLOSE, 0, 0L );
			break;
      } // end switch wParam
      break;
	 } // end case  WM_COMMAND
    //  (4) Respond to VBX Event
	 case WM_VBXFIREEVENT:
	 {
		VBXEVENT far *pVBXEvent;
		long ActiveRow;
		pVBXEvent=(VBXEVENT far *)lParam;
		//  (5) determine which VBX Event occurred
		switch( pVBXEvent->EventIndex )
		{
		  case Event_SpreadSheet_RightClick:
		  {
			 char temp[30];
			 long Col,Row;
			 HWND hwndCtl;
			 HCTL hCtl;
			 //  (6) Decode the event arguments
			 Col=VBX_EVENTARGNUM( pVBXEvent, long, 1 );
			 Row=VBX_EVENTARGNUM( pVBXEvent, long, 2 );
			 wsprintf(temp,"Right click in row: %ld col: %ld"
							  , Row, Col );
			 MessageBox( hwnd, temp, "VBX Event", MB_OK );
			 //  (7)  Read a property of the control
			 //  (7a) Get the window handle of the control
			 hwndCtl = GetDlgItem( hwnd, IDC_SPREAD1 );
			 //  (7b) Get the HCTL of the control
			 hCtl = VBXGetHctl( hwndCtl );
			 //  (7c) Get the data from the property of the control
			 VBXGetPropByName( hCtl, "ActiveRow",
									 (LPVOID)&ActiveRow );
			 wsprintf( temp, "ActiveRow Property = %ld",
							  ActiveRow );
			 MessageBox( hwnd, temp, "ActiveRow Property",
								MB_OK );
			 break;
		  } // end case  Right_Click
		} // end switch on EventIndex
		break;
	 } // end case WM_VBXFIREEVENT:
	 case WM_SIZE:
	 {
		RECT rect;
		GetClientRect( hwnd, &rect );
		MoveWindow( GetDlgItem( hwnd, IDC_SPREAD1 ), rect.left, rect.top,
						 rect.right, rect.bottom, FALSE );
		return 0;
		// break;
	 }
	 case WM_DESTROY:
			 PostQuitMessage(0);
			 return 0;
		  default: break;
  } // end switch..msg
  return DefWindowProc( hwnd, msg, wParam, lParam );
}

