#include <windows.h>
#include <bivbx.h>
#include "vbxdll.rh"

#define Event_SpreadSheet_RightClick 18

extern "C" BOOL FAR PASCAL DialogProc( HWND, UINT, WPARAM, LPARAM );
HINSTANCE hInst;

int FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD cbHeapSize, LPSTR lpCmdLine)
{
  hInst = hInstance;

  return 1;
}

// ===================================================== //
BOOL CALLBACK _export DialogProc( HWND hwnd, UINT msg,
					  WPARAM wParam, LPARAM lParam)
{
  BOOL result = TRUE;
  switch ( msg )
  {
	 case WM_INITDIALOG:
	 {
	 //  (2) Initialize control with DLGINIT data
	 VBXInitDialog( hwnd, hInst, "DIALOG_1" );
	 return TRUE;
	 }
	 case WM_COMMAND:
	 {
	 switch( wParam )
		case IDOK:
		case IDCANCEL:
		EndDialog( hwnd, wParam );
		result = 0;
		break;
	 }
	 //  (3) Respond to VBX Event
	 case WM_VBXFIREEVENT:
	 {
	 VBXEVENT far *pVBXEvent;
	 long ActiveRow;
	 pVBXEvent=(VBXEVENT far *)lParam;
	 // (4) determine which VBX Event occurred
	 switch( pVBXEvent->EventIndex )
	 {
		case Event_SpreadSheet_RightClick:
		{
		char temp[30];
		long Col,Row;
		HWND hwndCtl;
		HCTL hCtl;
		// (5) Decode the event arguments
		Col=VBX_EVENTARGNUM( pVBXEvent, long, 1 );
		Row=VBX_EVENTARGNUM( pVBXEvent, long, 2 );
		wsprintf( temp,"Right click in row: %ld col: %ld",
				Row, Col );
		MessageBox( hwnd, temp, "VBX Event", MB_OK );
		// (6)  Read a property of the control
		// (6a) Get the window handle of the control
		hwndCtl = GetDlgItem( hwnd, IDC_SPREAD1 );
		// (6b) Get the HCTL of the control
		hCtl = VBXGetHctl( hwndCtl );
		// (6c) Get the data from the property of the control
		VBXGetPropByName( hCtl, "ActiveRow",
						(LPVOID)&ActiveRow );
		wsprintf( temp, "ActiveRow Property = %ld",
				ActiveRow );
		MessageBox( hwnd, temp, "ActiveRow Property",
				  MB_OK );
		break;
		}
	 }
	 }
	 default:
	 result = FALSE;
  }
  return result;
}
