/* uzi.c -- Extract -ea4/-eb4 file from ZIP archive to standard output	*/
/* Kinch, March 1989							*/
/* Copyright (C) 1989, Kinch Computer Co.  All Rights Reserved		*/

char CopyRight[] = "Copyright (C) 1989, Kinch Computer Co.";

#include <stdio.h>
#include <fcntl.h>

/* The follower sets							*/
unsigned char S[256][32];
unsigned char N[256];
unsigned char B[256];
#define EMPTY(i) (N[(i)]==0)

unsigned long size;			/* Uncompressed size of output	*/

unsigned long
get2() {
    int c1,c2;
    unsigned long retval;
    c1 = getchar() & 0xff;
    c2 = getchar() & 0xff;
    retval = ((unsigned long)c1) |
	    (((unsigned long)c2)<<8);
    return(retval);
    }

unsigned long
get4() {
    int c1,c2,c3,c4;
    unsigned long retval;
    c1 = getchar() & 0xff;
    c2 = getchar() & 0xff;
    c3 = getchar() & 0xff;
    c4 = getchar() & 0xff;
    retval = ((unsigned long)c1) |
	    (((unsigned long)c2)<<8) |
	    (((unsigned long)c3)<<16) |
	    (((unsigned long)c4)<<24);
    return(retval);
    }

/* These store the left over bits for bitwise input.  The data is	*/
/* always right justified and unused bits are always zero.		*/
unsigned short leftover;		/* Data				*/
unsigned short nleft;			/* Nr of bits in leftover	*/

/* Mask the rightmost i bits						*/
unsigned short maskr[] = { 0, 1, 3, 7, 15, 31, 63, 127, 255 };

unsigned char
getbits(unsigned char n) {
    /* Get n bits from the input stream, right justified in return val	*/
    /* Works for up to 8 bit requests.					*/
    unsigned char retval;
    int c;
    /* Add another byte if we need the bits to satisfy the request	*/
    if (nleft<n) {
	leftover |= (c=getchar())<<nleft;
	nleft += 8;
	}
    /* How many bits will be left over					*/
    nleft -= n;
    /* Justify the return value						*/
    retval = leftover & maskr[n];
    /* Prune the leftovers						*/
    leftover >>= n;
    /* Deliver the result						*/
    return(retval);
    }

void
do_sets(void) {
    /* Read the follower sets						*/
    int i,j;
    for (j=255; j>=0; j--) {
	N[j] = getbits(6);
	if (N[j]>32) {
	    fprintf(stderr,"Funny N[%u]=%u\n",j,N[j]);
	    N[j] = 32;
	    }
	for (i=0; i<N[j]; i++) S[j][i] = getbits(8);
	if (N[j]<=2) B[j] = 1;
	else if (N[j]<=4) B[j] = 2;
	else if (N[j]<=8) B[j] = 3;
	else if (N[j]<=16) B[j] = 4;
	else B[j] = 5;
	}
    }

void
do_header(void) {

    unsigned int fnlen,xlen;

    if (get4()!=0x04034b50) {		/* Magic number			*/
	fputs("Input is not a ZIP file\n",stderr);
	exit(1);
	}
    get2();				/* Version			*/
    get2();				/* General			*/
    if (get2()!=5) {			/* Method			*/
	fputs("Compression method is not reduced-factor-4\n",stderr);
	exit(1);
	}
    get2();				/* Mod time			*/
    get2();				/* Mod date			*/
    get4();				/* CRC				*/
    get4();				/* Compressed size		*/
    size=get4();			/* Uncompressed size		*/
    fnlen=get2();			/* File name length		*/
    xlen=get2();			/* Extra info length		*/
    {   unsigned int i,c;		/* Name				*/
	for (i=0; i<fnlen; i++) c = getchar();
	}
    {   unsigned int i;			/* Extra info			*/
	for (i=0; i<xlen; i++) getchar();
	}
    do_sets();
    }

unsigned char lastc=0;

unsigned char
getprob(void) {
    /* Expand probabilistic compression based on the follower sets and	*/
    /* the input stream.  Return the next byte.				*/
    if (EMPTY(lastc)) return(lastc=getbits(8));
    if (getbits(1)) return(lastc=getbits(8));
    return(lastc=S[lastc][getbits(B[lastc])]);
    }

/* Compression factor 4 functions					*/
#define L(x) ((x)&0xf)
#define F(x) ((x)==15?2:3)
#define D(x,y) (((((unsigned int)x)&((unsigned int)0xf0))<<4)+((unsigned int)y)+1)

/* This is a queue which remembers the history of output, for use in	*/
/* expansion of repeated strings.  The size is determined by the	*/
/* largest value D(x,y) can produce where x and y are unsigned 8-bit	*/
/* integers.  The queue wraps around.  Variable hnext gives the next	*/
/* position to be written.  Entry hnext-1 is the last byte written out,	*/
/* hnext-2 the penultimate, hnext-3 the antepenult, and so on.  In	*/
/* each case we must compute with hnext modulo the size of history[].	*/
/* The C initializing to zeros of history[] will properly handle the	*/
/* case where history is not yet established.				*/
#define HISTORY 16*256		/* Most history we need for repeats	*/
unsigned char history[HISTORY];	/* The last HISTORY bytes of output	*/
unsigned int hnext;		/* Points to next history elmt to use	*/

void
repeat(void) {
    /* Expand repeated sequences					*/
    unsigned char state=0,c,v;
    unsigned int len;
    unsigned int h;		/* Pointer into history			*/
    unsigned int back;		/* How far back into history to go	*/
    unsigned int i,n;		/* Loop counters for copying history	*/

    if (!size) return;

    for (;;) {
	c = getprob();
	switch (state) {
	    case 0:
		    if (c!=144) {
			putchar(c);
			history[hnext++] = c;
			hnext %= HISTORY;
			if (!(--size)) return;
			}
		    else state = 1;
		    break;
	    case 1:
		    if (c) {
			v = c;
			len = L(v);
			state = F(len);
			}
		    else {
			putchar(144);
			history[hnext++] = 144;
			state = 0;
			if (!(--size)) return;
			}
		    break;
	    case 2:
		    len += c;
		    state = 3;
		    break;
	    case 3:
		    back = D(v,c);
		    if (back<=hnext) h = hnext - back;
		    else { h = (hnext+HISTORY);  h -= back; }
		    for (i=0,n=len+3; i<n; i++) {
			putchar(history[hnext++]=history[h++]);
			h %= HISTORY;
			hnext %= HISTORY;
			if (!(--size)) return;
			}
		    state = 0;
		    break;
	    }
	}
    }

main() {
#if MSDOS
    setmode(fileno(stdin),O_BINARY);
    setmode(fileno(stdout),O_BINARY);
#endif
    do_header();
    repeat();
    }
