/***************************************************************************

 FILENAME - TDENUMS.CPP: class TDEInteger
 ----------------------

 Class TDataEntry v1.0 - 07/14/92
 --------------------------------

 ----------------------------------------------------------------------------
 Author: Jeff Penrose * JDP Custom Software * (818) 344-7303 * CIS 71043,3727
 ----------------------------------------------------------------------------

 A data entry class for Borland's Turbo Vision, derived from TInputLine.

 Copyright Notice
 ================
  As this material is ultimately derived from Borland source files, any of
 their copyrights which MAY apply DO apply.
  From the author's standpoint, you may use this material freely and,
 hopefully, post any comments/corrections/enhancements to me at the above-
 noted addresses.  I do ask that you not distribute this material except as
 originally received, including all source/documentation files in their
 original form.
  If you DO modify or enhance any of this code, please send any such changes
 to me for incorporation into a future version.  Any such enhancements will
 be DONATED, without expectation of compensation or incorporation into
 future versions.  Again, if you distribute this code, please do so in its
 original, unmodified form including all source files and documentation.

 Source files included
 =====================
 TDE     .DOC: This documentation.
 TDE     .MAN: How to use TDataEntry in your dialog objects
 TDE     .H  : header file containing class declarations for classes
 TDEFLAGS.H  :   "     "      "       flags and command definitions
 TDE     .CPP: Class TDataEntry
 TDEDATE .CPP: Class TDEDate
 TDEPHONE.CPP: Classes TDEPhone, TDEZipCode, TDEState
 TDENUMS .CPP: Class TDEInteger
 TDECLUST.CPP: Non-TDataEntry classes TDEButton, TDERadioButtons, TDECheckBoxes
 TDEINPLI.CPP: Non-TDataEntry class TDEInputLine
 TDELIB  .PRJ: Project for building library TDELIB.LIB
 TDEDEMO .CPP: Demo program
 TDEDEMO .PRJ: Project for building TDEDEMO.EXE

***************************************************************************/
#define   Uses_TDEInteger
#define   Uses_TEvent
#include  "tde.h"
#include  <stdio.h>   // sprintf()
#include  <stdlib.h>  // atoi(), atof()

#ifndef __LIMITS_H    // for INT_MIN, INT_MAX
#include <limits.h>
#endif

#ifndef __STRING_H
#include <string.h>
#endif

#ifndef ulong
  typedef unsigned long  ulong;
#endif

//--------------------------------------------------------------------------
//
// **** TDEInteger::getData()
//
//--------------------------------------------------------------------------
void TDEInteger::getData( void *rec )
{
  int  i = atoi( data );
  memcpy( rec, &i, dataSize() );
}

//--------------------------------------------------------------------------
//
// **** TDEInteger::setData()
//
//--------------------------------------------------------------------------
void TDEInteger::setData( void *rec )
{
  origInt = *(int *)rec;

  if ( origInt == 0 )
    *data = EOS;
  else
    sprintf( data, "%*d", maxLen, origInt );
}

//--------------------------------------------------------------------------
//
// **** TDEInteger::handleEvent()
//
//--------------------------------------------------------------------------
void TDEInteger::handleEvent( TEvent& event )
{
  if ( event.what == evBroadcast )
  {
    switch ( event.message.command )
    {
      case cmTDQueryChanged:
        float val = atof(data);
        if ( val > INT_MAX || val < INT_MIN || (int)val != origInt )
          clearEvent(event);
        return;
      case cmTDGotoNumber:
        if ( localID == *(uchar *)event.message.infoPtr )
          clearEvent(event);
        return;
      case cmTDGotoName:
        if ( strcmp( fieldName, (char *)event.message.infoPtr ) == 0 )
          clearEvent(event);
        break;
      case cmTDResetData:
        origInt = atoi(data);
        return;
      default:
        break;
    }
  }
  TDataEntry::handleEvent(event);
}

//--------------------------------------------------------------------------
//
// **** TDEInteger::validData()
//
//--------------------------------------------------------------------------
Boolean TDEInteger::validData( const char *, const char * )
{
  float  val = atof( data );
  char   *msg = "\003Value out of range!";

  if ( val > INT_MAX || val < INT_MIN )
  {
    if ( (globalMode & tdgBeepEnable) != 0 )  cout << (char) 7;
    messageBox(msg, mfError | mfOKButton);
    select();
    return False;
  }
  return True;
}
