#ifndef _USER1_H
#define _USER1_H



#define Uses_TDialog

#include <tv.h>

#include "listview.h"


const int	cmRecAppend			=	1020;
const int	cmRecUpdate			=	1021;
const int	cmRecDelete			=	1022;

struct UserInfoRec
{
	uchar first[25];
	uchar middle[25];
	uchar last[25];
	uchar addr1[25];
	uchar addr2[25];
	uchar city[25];
	uchar state[3];
	uchar zip[10];
	uchar tel[11];
	uchar social[10];
	uchar password[25];
	ushort login;
	ushort aRights;
};

class DUserInfo : public TDialog
{
public:
	Boolean add;
public:
	DUserInfo();
	~DUserInfo();
	virtual Boolean valid(ushort);
	virtual void handleEvent(TEvent &);
	void setFlds(UserInfoRec *);
	void getFlds(UserInfoRec *);
	Boolean save();
};


class UserInfoListView : public ListViewer
{
private:
	UserInfoRec *u;
public:
	UserInfoListView(const TRect&, ushort, TScrollBar *, TScrollBar *);
	~UserInfoListView();
	void setValue(Boolean);
	virtual void handleEvent(TEvent &);
protected:
	virtual void getText( char *, short, short);
	Boolean isEmpty();
friend DUserInfoList;
	void edit();
	void del();
	void add();

};


class DUserInfoList : public TDialog
{
private:
	UserInfoListView *listView;
public:
	DUserInfoList();
	virtual void handleEvent(TEvent &);
};


struct LoginRec
{
	uchar id[25];
	uchar password[25];
};

class DLogin : public TDialog
{
private:
	LoginRec *data;
public:
	DLogin();
	~DLogin();
	virtual void handleEvent(TEvent &);
	int login();
	int login(Boolean);
	void setFlds(LoginRec *);
	void getFlds(LoginRec *);
};



#endif	//	_USER1_H