/*
	TTYWIN.CPP

	Copyright 1987-1993		Ambrose & Muckerman

	Written by:				Dan Ambrose
							Ambrose & Muckerman
	CIS ID:					71062,523
*/


#ifndef _TTYWIN_
#define _TTYWIN_


#include "TTYWIN.H"


TTYWindow::TTYWindow( TRect bounds, const char *winTitle,
	ushort windowNo, TTerminal *&interior, ushort aBufSize ) :

	TWindowInit( &TTYWindow::initFrame ),
	TWindow(bounds, winTitle, windowNo )
{
	flags &= ~wfClose;
	setState(sfShadow, False);
	bounds = getExtent();
	bounds.grow( -1, -1 );

	interior = new TTerminal( bounds, 0,
		standardScrollBar( sbVertical | sbHandleKeyboard ),
		aBufSize );

	insert( interior );
}


VTerminal::VTerminal( const TRect& bounds,
					TScrollBar *aHScrollBar,
					TScrollBar *aVScrollBar,
					ushort aBufSize ):
	TTerminal(bounds, aHScrollBar, aVScrollBar, aBufSize)
{

}

TPalette& VTerminal::getPalette() const
{
	#define cpBlueWindow "\x13\x13\x13\x13\x13\x13\x13\x0F"
	#define cpCyanWindow "\x10\x11\x12\x13\x14\x15\x16\x17"
	static TPalette c( cpCyanWindow, sizeof( cpCyanWindow )-1 );
	return c;
}


#endif