/***************************************************************************

 FILENAME - TDEPHONE.CPP: classes TDEPhone, TDEZipCode, TDEState
 -----------------------

 Class TDataEntry v1.0 - 07/14/92
 --------------------------------

 ----------------------------------------------------------------------------
 Author: Jeff Penrose * JDP Custom Software * (818) 344-7303 * CIS 71043,3727
 ----------------------------------------------------------------------------

 A data entry class for Borland's Turbo Vision, derived from TInputLine.

 Copyright Notice
 ================
  As this material is ultimately derived from Borland source files, any of
 their copyrights which MAY apply DO apply.
  From the author's standpoint, you may use this material freely and,
 hopefully, post any comments/corrections/enhancements to me at the above-
 noted addresses.  I do ask that you not distribute this material except as
 originally received, including all source/documentation files in their
 original form.
  If you DO modify or enhance any of this code, please send any such changes
 to me for incorporation into a future version.  Any such enhancements will
 be DONATED, without expectation of compensation or incorporation into
 future versions.  Again, if you distribute this code, please do so in its
 original, unmodified form including all source files and documentation.

 Source files included
 =====================
 TDE     .DOC: This documentation.
 TDE     .MAN: How to use TDataEntry in your dialog objects
 TDE     .H  : header file containing class declarations for classes
 TDEFLAGS.H  :   "     "      "       flags and command definitions
 TDE     .CPP: Class TDataEntry
 TDEDATE .CPP: Class TDEDate
 TDEPHONE.CPP: Classes TDEPhone, TDEZipCode, TDEState
 TDENUMS .CPP: Class TDEInteger
 TDECLUST.CPP: Non-TDataEntry classes TDEButton, TDERadioButtons, TDECheckBoxes
 TDEINPLI.CPP: Non-TDataEntry class TDEInputLine
 TDELIB  .PRJ: Project for building library TDELIB.LIB
 TDEDEMO .CPP: Demo program
 TDEDEMO .PRJ: Project for building TDEDEMO.EXE

***************************************************************************/
#define   Uses_TDEPhone
#define   Uses_TDEZipCode
#define   Uses_TDEState
#include  "tde.h"
#include  <stdlib.h>  // atof(), atol()
#include  <string.h>  // strlen(), strcpy(), strstr()

#ifndef ulong
  typedef unsigned long  ulong;
#endif

//--------------------------------------------------------------------------
//
// **** TDEPhone::valid()
//
//--------------------------------------------------------------------------
Boolean TDEPhone::valid(ushort cmd)
{
  if ( cmd == cmValid && !(maxLen == 7 || maxLen == 10) )
    return False;

  return TDataEntry::valid(cmd);
}

//--------------------------------------------------------------------------
//
// **** TDEPhone::validData()
//
//--------------------------------------------------------------------------
Boolean TDEPhone::validData( const char *, const char * )
{
  float    val;
  int      len = strlen(data);
  Boolean  dataOK = True;
  char     *msg = "\003Invalid phone number!";

  if ( !TDataEntry::validData(msg, "\003Phone number is required!") )
    return False;

  if ( len && !(len == 7 || len == 10) )
    dataOK = False;

  if ( dataOK && len )
  {
    val = atof(data);
    if ( len == 7 && (val < 1000000.0 || val > 9999999.0) )
      dataOK = False;
    else if ( len == 10 && (val < 1000000000.0 || val > 9999999999.0) )
      dataOK = False;
  }

  if ( !dataOK )
  {
    if ( (globalMode & tdgBeepEnable) != 0 )  cout << (char) 7;
    messageBox(msg, mfError | mfOKButton);
    select();
  }
  return dataOK;
}

//--------------------------------------------------------------------------
//
// **** TDEZipCode::valid()
//
//--------------------------------------------------------------------------
Boolean TDEZipCode::valid(ushort cmd)
{
  if ( cmd == cmValid && !(maxLen == 5 || maxLen == 9) )
    return False;

  return TDataEntry::valid(cmd);
}

//--------------------------------------------------------------------------
//
// **** TDEZipCode::validData()
//
//--------------------------------------------------------------------------
Boolean TDEZipCode::validData( const char *, const char * )
{
  ulong   val;
  int     len = strlen(data);
  Boolean dataOK = True;
  char    *msg = "\003Invalid zip code!";


  if ( !TDataEntry::validData(msg, "\003Zip code is required!") )
    return False;

  if ( len && !(len == 5 || len == 9) )
    dataOK = False;

  if ( dataOK && len )
  {
    val = atol(data);
    if ( len == 5 && (val < 10000UL || val > 99999UL) )
      dataOK = False;
    else if ( len == 9 && (val < 100000000UL || val > 999999999UL) )
      dataOK = False;
  }

  if ( !dataOK )
  {
    if ( (globalMode & tdgBeepEnable) != 0 )  cout << (char) 7;
    messageBox(msg, mfError | mfOKButton);
    select();
  }

  return dataOK;
}

//--------------------------------------------------------------------------
//
// **** TDEState::valid()
//
//--------------------------------------------------------------------------
Boolean TDEState::valid(ushort cmd)
{
  if ( cmd == cmValid && maxLen != 2 )
    return False;

  return TDataEntry::valid(cmd);
}

//--------------------------------------------------------------------------
//
// **** TDEState::validData()
//
//--------------------------------------------------------------------------
static char *states =
  "AL,AK,AZ,AR,CA,CO,CT,DC,DE,FL,GA,HI,ID,IL,IN,IA,KS,KY,LA,ME,MD,MA,MI,MN,"
  "MS,MO,MT,NE,NV,NH,NJ,NM,NY,NC,ND,OH,OK,OR,PA,RI,SC,SD,TN,TX,UT,VT,VA,WA,"
  "WV,WI,WY";

Boolean TDEState::validData( const char *, const char *)
{
  int     len = strlen(data);
  Boolean dataOK = True;
  char    *msg   = "\003Invalid state!";


  if ( !TDataEntry::validData(msg, "\003State is required!") )
    return False;

  if ( len && len != 2 )
    dataOK = False;

  if ( dataOK && len && !( strstr(states, data) ) )
    dataOK = False;

  if ( !dataOK )
  {
    if ( (globalMode & tdgBeepEnable) != 0 )  cout << (char) 7;
    messageBox(msg, mfError | mfOKButton);
    select();
  }

  return dataOK;
}
