/*
    usrif.h

    user interface header file
*/

#include "defs.h"

/* event manager type definitions */
#define NULL_EVENT         0
#define DN_BUTTON_EVENT    1
#define UP_BUTTON_EVENT    2
#define KEY_EVENT          3
#define ABORT_EVENT        4

struct  event_record
    {
    int     what;
    char    stroke;
    point_t where;
    };

typedef struct event_record event_t;
event_t *get_next_event();

/* window manager definitions */

struct  window_record
    {
    int (*key_fn)(),        /* window key function */
        (*button_fn)();     /* window button function */

    char    *name;
    seg_t   *shape, *data;
    rect_t  *data_win,
            *area,
            *title,
            *pane;

    struct  window_record *next, *prev;
    };

typedef struct window_record window_t;

#define MAX_WINDOWS 20

window_t    *what_window(),
            *front_window();

/* maximum number of menu items */
#define MAX_MENUS 16
