/*
    main.c

    user interface demonstration file
*/

#include "usrif.h"
#undef    NULL
#include "stdio.h"

main(argc, argv)
int     argc;
char    *argv[];
{
event_t     *myevent;
window_t    *mywindow;
void	    init_app();

    /* initialize segmentation system */
    initialize();

    /* initialize event and window managers */
    init_event();
    init_window();

    /* initialize application */
    init_app();

    /* enter event-driven user interface */
    while(TRUE)
        {
        /* get an event */
        myevent = get_next_event();

        /* What kind of event was it? */
        switch( myevent->what )
            {
            case    NULL_EVENT  :
                /* use this event for
                   pseudobackground processes */
                break;

            case    ABORT_EVENT :
                /* interrupt! */
                break;

            case    KEY_EVENT   :

                /* In what window did the KEY_EVENT occur? */
                mywindow = what_window( &(myevent->where));

                if( mywindow == NULL)
                    {
                    /* must have been a desktop event */
                    desktop( myevent);
                    }
                else if( mywindow == front_window())
                    {
                    /* call key function */
                    if( mywindow->key_fn != NULL)
                        (*(mywindow->key_fn))(myevent, mywindow);
                    }
                else
                    /* keypress in obscured window */
                    pop_window( mywindow);

               break;

            case    DN_BUTTON_EVENT :  /* button down */

                /* In what window did DN_BUTTON_EVENT occur? */
                mywindow = what_window( &(myevent->where));

                if( mywindow == NULL)
                    {
                    /* must have been a desktop event */
                    desktop( myevent);
                    }

                else if( mywindow == front_window())
                    {
                    if( in_title( &(myevent->where), mywindow))
                        /* call window-control function */
                        mod_window( myevent, mywindow);

                    else if( mywindow->button_fn != NULL)
                        /* call button function */
                        (*(mywindow->button_fn))(myevent, mywindow);
                    }
                else
                    /* button down in obscured window */
                    pop_window( mywindow);

                break;
            }

        }   /* loop forever */
}

/*
    application test code
*/

#define WINDOWS 4
seg_t    *door, *window, *house;
window_t *them[WINDOWS];

void    init_app()
{
window_t  *new_window();
seg_t     *cl_seg();

/*
    initialize application variables, windows, menu functions, etc.
*/

        cr_seg("window");
        add_attr(RESET);
        add_attr(BLACK);
        rect(10,10,60,80);
        rect(10,00,60,90);
        window = cl_seg();

        cr_seg("door");
        add_attr(RESET);
        add_attr(BLACK);
        rect(10,0,100,170);
        door = cl_seg();

        cr_seg("house");

        add_attr(RESET);
        add_attr(BLACK);

        rect(100,200,600,500);
        begin_line();
            con_point(50,480);
            con_point(350,600);
            con_point(650,480);
        add_line(end_line());

        ref("window",150,300,NULL);
        ref("window",250,300,NULL);
        ref("window",350,300,NULL);

        ref("door",450,200,NULL);

        text("House", 0, 100, LEFT , BOTTOM);

    house = cl_seg();

/*
    display house segment in four different windows
*/

    them[0] = new_window("Window 0", house, new_rect());
    them[1] = new_window("Window 1", house,
         inst_rect(150, 50,300,600));
    them[2] = new_window("Window 2", house, new_rect());
    them[3] = new_window("Window 3 is the last", house,
         inst_rect(100,100,600,300));

/*
    return to event loop
*/
}
