/*
    event.c

    event manager routines and variables
*/

/*
    #include system-dependent header files here
*/

#include "usrif.h"
#undef   NULL
#include "ctype.h"
#include "stdio.h"

/* cursor record */
extern  point_t cursor;

/* keyboard lookup table */
char    key_map[256];

extern  rect_t  screen;

/* the event record */
event_t the_event;

/*
    initialize event manager
*/

void    init_event()
{
int i;

    /* initial cursor position */
    cursor.x = cursor.y = 0;

    /* default ascii keyboard lookup table */
    for(i=0;i<256;i++)
        if(isascii(i))
            key_map[i] = (char) i;
        else
            key_map[i] = '\0';

    /* initialize system-dependent event managers here */
}

event_t *get_next_event()
{
point_t where;
int     data;

    /* get system event */

    switch(type)    /* What type of event was it? */
        {
        case   /* no event */   :

            the_event.what = NULL_EVENT;
            break;

        case    /* button event */    :

            /* down button? */
               the_event.what = DN_BUTTON_EVENT;

            /* up button? */
               the_event.what = UP_BUTTON_EVENT;

            break;

        case    /* pointer moved */   :

            where.x = /* pointer x location */
            where.y = /* pointer y location */
            set_cursor( &where);

            /* movement of pointer is not event */
            the_event.what = NULL_EVENT;
            break;

        case    /* key was pressed */ :

            /* keyboard key is in data */

            the_event.stroke = key_map[data];
            the_event.what = KEY_EVENT;

            if(data == ABORT_KEY)
                the_event.what = ABORT_EVENT;

            break;
        }

    /* set up the event record */
    the_event.where.x = cursor.x;
    the_event.where.y = cursor.y;

    return( &the_event );
}
