/*
    display.c

    miscellaneous display routines
*/

#include "usrif.h"
#undef   NULL
#include <ctype.h>
#include <stdio.h>

/*
    #include system-dependent header files here
*/

/* globals */
extern  rect_t  screen;
extern  vport_t *the_port;

/* desktop segment pointers */
seg_t   *desk_seg = NULL;
seg_t   *trash;

/* current and last cursor positions */
point_t cursor,
        last_loc;

int     erase = FALSE;

/* cursor operations */

/* set new cursor position */
void    set_cursor(loc)
point_t *loc;
{
    void xor_cursor();

    if(erase == FALSE)
        {
        erase = TRUE;
        last_loc.x = loc->x;
        last_loc.y = loc->y;
        xor_cursor(loc);
        }
    else if( (last_loc.x != loc->x) || (last_loc.y != loc->y) )
        {
        xor_cursor(&last_loc);
        last_loc.x = loc->x;
        last_loc.y = loc->y;
        xor_cursor(loc);
        }
    cursor.x = loc->x;
    cursor.y = screen.top - loc->y;
}

/* get current cursor position */
void    get_cursor( pt )
point_t *pt;
{
    if(pt == NULL)
        return;

    pt->x = cursor.x;
    pt->y = cursor.y;
}

/*
    cursor hide and show functions
*/

int view_status = FALSE;

void    hide_cursor()
{
    void xor_cursor();

    if(view_status == FALSE)
        {
        xor_cursor(&last_loc);
        erase = FALSE;
        }
    view_status++;
}

void    show_cursor()
{
    point_t loc;

    if(view_status == 1)
        {
        loc.x = cursor.x;
        loc.y = screen.top - cursor.y;
        set_cursor(&loc);
        }
    --view_status;
}

/*
    cursor drawing functions
*/

void    xor_cursor(loc)
point_t *loc;
{
/*
    exclusive OR the current cursor
    in the bit map at location 'loc'
*/
}

/* desktop operations */

/* make desktop */
void    make_desktop()
{
    /* trash icon */
    cr_seg("trash");
        add_attr(RESET);
        add_attr(NOFILL);
        add_attr(BLACK);

        rect(7,1,25,24);
        rect(6,24,26,26);
        rect(13,26,19,28);

        begin_line();
            con_point(10,3);
            con_point(10,22);
        add_line(end_line());

        begin_line();
            con_point(13,3);
            con_point(13,22);
        add_line(end_line());

        begin_line();
            con_point(19,3);
            con_point(19,22);
        add_line(end_line());

        begin_line();
            con_point(22,3);
            con_point(22,22);
        add_line(end_line());

        text("Trash", 16, 0, MIDDLE , TOP);
    trash = cl_seg();

    cr_seg("desk_top");
        add_attr(RESET);

        /* desktop background of white */
        add_attr(FILL);
        add_rect(&screen);
        ref("trash" ,screen.right-70,20,NULL);

    desk_seg = cl_seg();
}

#define CANCEL  0
#define PRINT   1
#define CLALL   2
#define QUIT    3

char    *desk_ops[4] =
    {
    "Cancel",
    "Print",
    "Close All",
    "Quit"
    };

void    desktop(event)
event_t     *event;
{
int sel;

    if(event->what == DN_BUTTON_EVENT)
        {
        sel = pop_up_menu( 4, desk_ops );

        switch(sel)
            {
            case  CANCEL  : /* nothing */   break;
            case  PRINT   : print_screen(); break;
            case  CLALL   : purge_all();    break;
            case  QUIT    : exit();
            }
        }
    else if(event->what == KEY_EVENT)
        {
        /* perform desktop key function */
        }
}
