/*
** wintestn.c
**
** Test 23 of the SM window system.
** Window gainfocus / losefocus event callback test.
**
** Copyright 1994
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
*/

#include <stdio.h>
#include <string.h>

#include "smtypes.h"
#include "smwindow.h"
#include "smevent.h"
#include "smmenu.h"
#include "smcolor.h"
#include "smgraph.h"

int LoseFocus(WindowType *w);
int GainFocus(WindowType *w);

extern FILE *ferr;

main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w1, *w2;
    RectType    rt;

    ferr = NULL;
    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Multiple Windows", NULL);

    /*
    ** Create and open an application window
    */
    rt.Xmin = rt.Ymin = 180;
    rt.Xmax = rt.Ymax = 180+247;
    w1 = SM_NewWindow(&rt, "Test Window 1", DOCUMENT | BACKING, NULL, NULL);
    rt.Xmin += 20;
    rt.Ymin += 20;
    rt.Xmax += 20;
    rt.Ymax += 20;
    w2 = SM_NewWindow(&rt, "Test Window 2", DOCUMENT | BACKING, NULL, NULL);
    SM_SetContentColor(w1, SM_GetSystemColor(SMLIGHTGRAY));
    SM_SetContentColor(w2, SM_GetSystemColor(SMLIGHTGRAY));

    SM_SetGainFocusProc(w1, GainFocus);
    SM_SetGainFocusProc(w2, GainFocus);
    SM_SetLoseFocusProc(w1, LoseFocus);
    SM_SetLoseFocusProc(w2, LoseFocus);

    SM_OpenWindow(w1);
    SM_OpenWindow(w2);

    /*
    ** Event loop...
    */
    if (ferr == NULL) {
        ferr = fopen("wintestn.out","wb");
    }

    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_Exit(NULL);
        }
    }
}

/*****************************************************************************
**
** GainFocus
**
** This function will be called when the window gets focus
*/
int GainFocus(WindowType *w)
{
    fprintf(ferr, "Window %s getting input focus\n", SM_GetWindowTitle(w));
}

/*****************************************************************************
**
** LoseFocus
**
** This function will be called when the window gets focus
*/
int LoseFocus(WindowType *w)
{
    fprintf(ferr, "Window %s losing input focus\n", SM_GetWindowTitle(w));
}


