/*
** wintestk.c
**
** File dialog test
**
** Copyright 1992, 1993, 1994 by
** Dean Clark
** TWS
** PO Box 37464
** Albuquerque, NM  87176
**
*/

#include <stdio.h>
#include <alloc.h>
#include "smwindow.h"
#include "smevent.h"
#include "filedial.h"
#include "smlabel.h"
#include "smwutil.h"

extern FILE *ferr;

/*
** Borlandc requires extra stack
*/
#ifdef __TURBOC__
extern unsigned _stklen = 14336U;
#endif

int LabelUpdate(WindowType *w, EventType *ev);
void PrntScrn(WindowType *w, RectType *r, char *fname);

main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    char        *fname;
    PanelType   *panel;
    LabelType   *label;
    char        memmsg[80];
    RectType    r;
    unsigned long   memleft;

    ferr = NULL;

    SM_Init(argc, argv);
    SM_OpenApplication("TWS Demo : File Dialog", NULL);
    panel = SM_CreatePanel(40, DOWN);
    r.Xmin = 220;
    r.Ymax = 27;
    r.Xmax = r.Xmin + 200;
    r.Ymin = r.Ymax - SM_GetSystemFontHeight() - 4;

    memleft = coreleft();
    sprintf(memmsg, "Mem Avail : %ld", memleft);

    label = SM_CreateLabel(panel,
                           &r,
                           memmsg,
                           NULL,
                           ALIGNCENTER,
                           False,
                           False,
                           True,
                           (void *)memleft);

    SM_SetUserData((WindowType *)panel, (void *)label);
    SM_InitBackgroundProcs();
    SM_RegisterBackgroundProc((WindowType *)panel, LabelUpdate, ALLEVENTS);

    SM_SetPrintscreenProc(NULL, NULL, "panel.pcx", PrntScrn);

    fname = SM_GetFilename("*.c");

    if (ferr == NULL) {
        ferr = fopen("wintestk.out","wb");
    }

    fprintf(ferr, "File selected is %s\n", fname);

    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            fprintf(ferr,"Key %0x, Code %0x\n",ev->ASCII, ev->ScanCode);
            if (ev->ASCII == 'q') SM_Exit(NULL);
        }
    }

}


int LabelUpdate(WindowType *w, EventType *ev)
{
    unsigned long   memleft, newmemleft;
    LabelType       *label;
    char            msg[50];

    label = (LabelType *)SM_GetUserData(w);
    memleft = (unsigned long)SM_GetLabelData(label);
    newmemleft = coreleft();
    if (newmemleft != memleft) {
        sprintf(msg, "Mem Avail : %ld", newmemleft);
        SM_SetLabelString(label, msg);
        SM_SetLabelData(label, (void *)newmemleft);
    }
    return 0;
}

void PrntScrn(WindowType *w, RectType *r, char *fname)
{
    SM_SaveScreenAsPCX(fname);
}


