/*
** wintesth.c
**
** Test 17 of the SM window system.
** Testing pixmaps in a button.
**
** Copyright  1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
*/

#include <stdio.h>

#include <smwindow.h>
#include <smevent.h>
#include <smbutton.h>
#include <smcolor.h>
#include <smgraph.h>
#include <smpixmap.h>

extern FILE *ferr;
extern unsigned _stklen = 16328U;

int ButtonUserproc(ButtonType *b);

main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w;
    ButtonType  *b1, *b2;
    RectType    r;
    PixmapType  *pm;
    int         i, j;

    ferr = NULL;
    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Pixmaps", NULL); /* Create application screen    */

    /*
    ** Create and open an application window
    */
    r.Xmin = r.Ymin = 180;
    r.Xmax = r.Ymax = 400;
    w = SM_NewWindow(&r, "Test Window", DOCUMENT | NOBACKING, NULL, NULL);
    SM_SetContentColor(w, SM_GetSystemColor(SMLIGHTGRAY));


    /*
    ** Add a button before the window is opened
    */
    r.Xmin = r.Ymin = 10;
    r.Xmax = r.Xmin + GR_StringWidth("  Button 1  ");
    r.Ymax = r.Ymin + 24;
    b1 = SM_CreateButton(w,
                         &r,
                         "Button 1",
                         (void *)1,
                         ButtonUserproc);

    /*
    ** Create the button pixmap
    */
    r.Xmax -= r.Xmin;
    r.Ymin -= r.Ymin;
    r.Xmin = r.Ymin = 0;
    pm = SM_CreatePixmap(NULL, &r, SMDEFAULT);

    SM_SetPixmapBlocking(pm, True);

    /*
    ** Put a random pattern in the pixmap; only use the system colors
    */
    for (i = 0; i < SM_GetPixmapWidth(pm); i++) {
        for (j = 0; j < SM_GetPixmapDepth(pm); j++) {
            SM_SetPixmapPixel(pm, i, j, SM_GetSystemColor((i+j)%8));
        }
    }

    /*
    ** Attach the pixmap to the button
    */
    SM_SetButtonPixmap(b1, pm);


    SM_OpenWindow(w);

    /*
    ** Add another button after the window has been opened
    */
    r.Ymin = r.Ymax + 8;
    r.Ymax = r.Ymin + 24;
    b2 = SM_CreateButton(w,
                         &r,
                         "Button 2",
                         (void *)2,
                         ButtonUserproc);
    SM_SetButtonIsdefault(b1, True);

    /*
    ** Event loop...
    */
    if (ferr == NULL) {
        ferr = fopen("wintesth.out","wb");
    }
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_Exit(NULL);
        }
    }
}

int ButtonUserproc(ButtonType *b)
{
    int n;

    n = (int)SM_GetButtonData(b);
    fprintf(ferr,"Button %d activated!\n", n);
    return True;
}
