/*
** wintestf.f
**
** Test 15 of the SM window system.
** Picklist test
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
*/

#include <stdio.h>
#include <string.h>

#include <smtypes.h>
#include <smwindow.h>
#include <smevent.h>
#include <smcolor.h>
#include <smgraph.h>
#include <smpickls.h>

extern FILE *ferr;
int Win_Draw(WindowType *w);

int DoSlider(SliderType *s);


main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w;
    RectType    rt;
    char        *list[10];

    ferr = NULL;
    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Picklist Composite Gadget", NULL);

    /*
    ** Create and open an application window
    */
    rt.Xmin = rt.Ymin = 180;
    rt.Xmax = rt.Ymax = 180+247;
    w = SM_NewWindow(&rt, "Test Window 1", DOCUMENT | NOBACKING, NULL, NULL);
    SM_SetContentColor(w, SM_GetSystemColor(SMLIGHTGRAY));

    /*
    ** Create the list to pick from
    */
    list[0] = "ADRIENNE.GIF";
    list[1] = "BARBARA.GIF";
    list[2] = "COLETTE.GIF";
    list[3] = "DIANE.GIF";
    list[4] = "EVONNE.GIF";
    list[5] = "FRANCIS.GIF";
    list[6] = "GRETCHEN.GIF";
    list[7] = "HANNAH.GIF";
    list[8] = "IRENE.GIF";
    list[9] = "JUDY.GIF";

    /*
    ** Set up the box for the strings
    */
    rt.Xmin = rt.Ymin = 100;
    rt.Xmax = rt.Xmin + GR_StringWidth(" ADRIENNE.GIF ");
    rt.Ymax = rt.Ymin + 100;

    SM_OpenWindow(w);

    msg = SM_Picklist("GIF Files",      /* Picklist window title            */
                      &rt,              /* Boundary for the strings         */
                      list,             /* Strings to pick from             */
                      10,               /* Number of strings                */
                      0,                /* Index of first string            */
                      0,                /* Which selected                   */
                      False);           /* Let the destructor free the list */
    /*
    ** Event loop...
    */
    if (ferr == NULL) {
        ferr = fopen("wintestf.out","wb");
    }
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_Exit(NULL);
        }
    }
}


int DoSlider(SliderType *s)
{
    fprintf(ferr,"Slider position == %d\n",SM_GetSliderPosition(s));
}


