/*
** winteste.c
**
** Test 14 of the SM window system.
** Scroll bar test
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "smtypes.h"
#include "smwindow.h"
#include "smevent.h"
#include "smcolor.h"
#include "smgraph.h"
#include "smscroll.h"
#include "smlabel.h"
#include "smwutil.h"

extern FILE *ferr;
int Win_Draw(WindowType *w);
void PrntScrn(WindowType *w, RectType *r, char *fname);

int DoSlider(SliderType *s);


main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w;
    ScrollbarType  *v, *h;
    RectType    rt;
    char        *list[10];
    LabelType   *hlabel, *vlabel;
    char        vstr[6], hstr[6];

    ferr = NULL;
    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Scrollbar Gadget", NULL);

    /*
    ** Create and open an application window
    */
    rt.Xmin = rt.Ymin = 180;
    rt.Xmax = rt.Ymax = 180+247;
    w = SM_NewWindow(&rt, "Test Window 1", DOCUMENT | NOBACKING, NULL, NULL);
    SM_SetContentColor(w, SM_GetSystemColor(SMLIGHTGRAY));

    /*
    ** Create the scrollbar
    */
    rt.Xmin = rt.Ymin = 4;
    rt.Ymax = SM_GetContentDepth(w) - 4;
    rt.Xmax = rt.Xmin + 24;
    v = SM_CreateScrollbar(w,
                        &rt,            /* Slider channel boundary          */
                        VERTICAL,       /* Slider type                      */
                        100,            /* Minimum slider value             */
                        0,              /* Max slider value                 */
                        1,              /* Pixels per controlled object     */
                        0,              /* Initial position                 */
                        NULL,           /* User data                        */
                        DoSlider);      /* User function                    */

    /*
    ** Create the scrollbar
    */
    rt.Xmin = rt.Xmax + 4;
    rt.Xmax = SM_GetContentWidth(w) - 4;
    rt.Ymin = rt.Ymax - 24;
    h = SM_CreateScrollbar(w,
                        &rt,            /* Slider channel boundary          */
                        HORIZONTAL,     /* Slider type                      */
                        -100,           /* Minimum slider value             */
                        0,              /* Max slider value                 */
                        1,              /* Pixels per controlled object     */
                        0,              /* Initial position                 */
                        NULL,           /* User data                        */
                        DoSlider);      /* User function                    */

    /*
    ** make a label for the scrollbar value
    */
    rt.Xmin = 35;
    rt.Xmax = rt.Xmin + 50;
    rt.Ymin = 5;
    rt.Ymax = rt.Ymin + 20;
    vlabel = SM_CreateLabel(w,
                            &rt,
                            itoa(0, vstr, 10),
                            NULL,
                            ALIGNCENTER,
                            False,
                            False,
                            True,
                            NULL);
    SM_SetScrollbarData(v, (void *)vlabel);

    /*
    ** Create a label for this scrollbar
    */
    rt.Xmax = SM_GetContentWidth(w) - 5;
    rt.Xmin = rt.Xmax - 50;
    rt.Ymax = SM_GetContentDepth(w) - 35;
    rt.Ymin = rt.Ymax - 20;
    hlabel = SM_CreateLabel(w,
                            &rt,
                            itoa(0, hstr, 10),
                            NULL,
                            ALIGNCENTER,
                            False,
                            False,
                            True,
                            NULL);
    SM_SetScrollbarData(h, (void *)hlabel);
    SM_SetPrintscreenProc(NULL, NULL, "scroll.pcx", PrntScrn);

    SM_OpenWindow(w);

    /*
    ** Event loop...
    */
    if (ferr == NULL) {
        ferr = fopen("winteste.out","wb");
    }

    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            if ((ev->ASCII >= '0') && (ev->ASCII <= '9')) {
                msg = (ev->ASCII - '0')*10;
                fprintf(ferr, "  Setting position to %d\n", msg);
                SM_SetScrollbarPosition(v, msg);
                SM_SetScrollbarPosition(h, -msg);
                msg = SM_GetScrollbarPosition(v);
                fprintf(ferr,"  New position = %d\n",msg);
            }
            else {
                SM_Exit(NULL);
            }
        }
    }
}


int DoSlider(SliderType *s)
{
    LabelType   *label;
    char        str[7];

    label = (LabelType *)SM_GetSliderData(s);
    itoa(SM_GetSliderPosition(s), str, 10);
    SM_SetLabelString(label,str);
}

void PrntScrn(WindowType *w, RectType *r, char *fname)
{
    SM_SaveScreenAsPCX(fname);
}


