/*
** wintestd.c
**
** Test 13 of the SM window system.
** String list test
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
*/

#include <stdio.h>
#include <string.h>

#include "smtypes.h"
#include "smwindow.h"
#include "smevent.h"
#include "smcolor.h"
#include "smgraph.h"
#include "smstrlst.h"

extern FILE *ferr;
int Sout(StringlistType *s);

main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w;
    StringlistType  *s;
    RectType    rt;
    char        *list[50];

    ferr = NULL;
    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Stringlist Gadget", NULL);

    w = SM_WorkspaceWindow();

    /*
    ** Create a string list
    */
    list[0] = "0  This";
    list[1] = "1  is";
    list[2] = "2  a";
    list[3] = "3  Stringlist";
    list[4] = "4  gadget";
    list[5] = "5  from";
    list[6] = "6  the";
    list[7] = "7  SM";
    list[8] = "8  Windowing";
    list[9] = "9  system.";
    list[10] = "10 This";
    list[11] = "11 is";
    list[12] = "12 a";
    list[13] = "13 Stringlist";
    list[14] = "14 gadget";
    list[15] = "15 from";
    list[16] = "16 the";
    list[17] = "17 SM";
    list[18] = "18 Windowing";
    list[19] = "19 system.";
    list[20] = "20 This";
    list[21] = "21 is";
    list[22] = "22 a";
    list[23] = "23 Stringlist";
    list[24] = "24 gadget";
    list[25] = "25 from";
    list[26] = "26 the";
    list[27] = "27 SM";
    list[28] = "28 Windowing";
    list[29] = "29 system.";
    rt.Xmin = rt.Ymin = 5;
    rt.Xmax = rt.Xmin + GR_StringWidth(" Unboxed Label ");
    rt.Ymax = rt.Ymin + 6 * SM_GetSystemFontHeight();

    s = SM_CreateStringlist(w,
                            &rt,        /* Bounding rectangle               */
                            list,       /* List of strings to display       */
                            30,         /* Number of items in the list      */
                            0,          /* Item at top of display           */
                            1,          /* Number of columns                */
                            Sout,       /* User function                    */
                            False,      /* Destroy flag                     */
                            True,       /* Scroll flag                      */
                            False,      /* Allow multiple selections        */
                            NULL);      /* User data                        */
    rt.Xmin = rt.Xmax + 50;
    rt.Xmax = rt.Xmin + GR_StringWidth(" Unboxed Label    Boxed Label Here");

    s = SM_CreateStringlist(w,
                            &rt,        /* Bounding rectangle               */
                            list,       /* List of strings to display       */
                            30,         /* Number of items in the list      */
                            0,          /* Item at top of display           */
                            2,          /* Number of columns                */
                            Sout,       /* User function                    */
                            False,      /* Destroy flag                     */
                            True,       /* Scroll flag                      */
                            False,      /* Allow multiple selections        */
                            NULL);      /* User data                        */

    rt.Xmin = 10;
    rt.Ymin = rt.Ymax + 50;
    rt.Xmax = rt.Xmin + GR_StringWidth(" Unboxed Label    Boxed Label Here   Next column");
    rt.Ymax = rt.Ymin + 6 * SM_GetSystemFontHeight();

    s = SM_CreateStringlist(w,
                            &rt,        /* Bounding rectangle               */
                            list,       /* List of strings to display       */
                            30,         /* Number of items in the list      */
                            0,          /* Item at top of display           */
                            4,          /* Number of columns                */
                            Sout,       /* User function                    */
                            False,      /* Destroy flag                     */
                            True,       /* Scroll flag                      */
                            False,      /* Allow multiple selections        */
                            NULL);      /* User data                        */

    /*
    ** Event loop...
    */
    if (ferr == NULL) {
        ferr = fopen("wintestd.out","wb");
    }

    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_Exit(NULL);
        }
    }
}



int Sout(StringlistType *s)
{
    fprintf(ferr, "String selected = %d\n", SM_GetStringlistSelection(s));
    return True;
}
