/*
** wintesta.c
**
** Test 10 of the SM window system.
** Multiple window test.
**
** This program tests:
**
**    * Backing store/restore
**    * Bring-to-front mechanism
**    * Color sharing
**    * Window closing
**
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Thu  07-02-1992
** Original version
*/

#include <stdio.h>
#include <string.h>

#include "smtypes.h"
#include "smwindow.h"
#include "smevent.h"
#include "smmenu.h"
#include "smcolor.h"
#include "smgraph.h"

int Win_Draw(WindowType *w);

main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w1, *w2;
    RectType    rt;
    int         i, r, g, b;
    ColorType   *c;

    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    SM_OpenApplication("TWS Demo : Multiple Windows", NULL);

    /*
    ** Create and open an application window
    */
    rt.Xmin = rt.Ymin = 180;
    rt.Xmax = rt.Ymax = 180+247;
    w1 = SM_NewWindow(&rt, "Test Window 1", DOCUMENT | BACKING, NULL, NULL);
    rt.Xmin += 15;
    rt.Ymin += 15;
    rt.Xmax += 15;
    rt.Ymax += 15;
    w2 = SM_NewWindow(&rt, "Test Window 2", DOCUMENT | BACKING, NULL, NULL);
    SM_SetContentColor(w1, SM_GetSystemColor(SMLIGHTGRAY));
    SM_SetContentColor(w2, SM_GetSystemColor(SMLIGHTGRAY));

    rt.Xmin = rt.Ymin = 10;
    rt.Xmax = -500;
    rt.Ymax = -500;

    GR_CreateGraphState(w1, &rt, GRRECESSBORDER);
    GR_CreateGraphState(w2, NULL, SMDEFAULT);

    /*
    ** Allocate a color table for this window...
    */
    SM_CreateWindowPalette(w1, 247);
    SM_CreateWindowPalette(w2, 247);
    r = 255;
    g = 255;
    b = 4;
    for (i = 0; i < 247; i++) {
        b++;
        r--;
        g--;
        SM_SetWindowColor(w1, i, r, g, b, SMSHARE | SMCLOSESTCOLOR);
    }
    r = g = 4;
    b = 255;
    for (i = 0; i < 247; i++) {
        b--;
        r++;
        g++;
        SM_SetWindowColor(w2, i, r, g, b, SMSHARE | SMCLOSESTCOLOR);
    }


    SM_SetDrawProc(w1, Win_Draw);
    SM_SetDrawProc(w2, Win_Draw);
    SM_OpenWindow(w1);
    SM_OpenWindow(w2);

    /*
    ** Event loop...
    */
    i = 0;
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            if (i) SM_Exit(NULL);
            SM_BringToFront(w1);
            i++;
        }
    }
}


int Win_Draw(WindowType *w)
{
    int x, y;
    int i , j, k;
    ColorType *c;

    x = GR_GetCanvasWidth(w);
    y = GR_GetCanvasDepth(w);
    k = 0;
    GR_SetBlocking(w);
    for (i = 0; i < y; i++) {
        for (j = 0; j < x; j++) {
            c = SM_GetWindowColor(w, k);
            GR_SetDrawColor(w, c);
            GR_DrawPoint(w, j, i);
            k++;
            if (k == 247) {
                k = 0;
            }
        }
    }
    GR_UnsetBlocking();
    GR_SetDrawColor(w, SM_GetSystemColor(SMWHITE));
    GR_MoveTo(w, 0, 0);
    GR_LineTo(w, x-1, 0);
    GR_LineTo(w, x-1, y-1);
    GR_LineTo(w, 0, y-1);
    GR_LineTo(w, 0, 0);
}
