/*
** wintest7.c
**
** Test 7 of the SM window system.
** Test of the editstring gadget. The editstring is attached to the desktop
** window.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Wed  07-01-1992
** Original version
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>

#include "smtypes.h"
#include "smwindow.h"
#include "smevent.h"
#include "smeditst.h"
#include "smmenu.h"

#ifdef __TURBOC__
extern unsigned _stklen = 8192U;
#endif


main(int argc, char **argv)
{
    EventType   *ev;
    int         msg;
    WindowType  *w;
    EditstringType  *e, *e2, *e3;
    RectType    r;
    char        string[100];
    int         EdstrFunc(EditstringType *, EventType *);


    /*
    ** Initialize the window system, graphics, fonts, etc.
    */
    SM_Init(argc, argv);

    /*
    ** Open the application
    */
    w = SM_OpenApplication("TWS Demo : Editstring Gadget", NULL);

    /*
    ** Create the editstring
    */
    r.Xmin = 10;
    r.Xmax = 350;
    r.Ymin = 25;
    r.Ymax = r.Ymin + SM_GetSystemFontHeight() + 4;
    e = SM_CreateEditstring(w,
                            &r,
                            "First test string",
                            128,
                            NULL,
                            EdstrFunc);
    r.Ymin = r.Ymax + 5;
    r.Ymax = r.Ymin + SM_GetSystemFontHeight() + 4;
    strcpy(string, "Now is the winter of our discontent.");
    e2 = SM_CreateEditstring(w,
                            &r,
                            "Second test string",
                            128,
                            NULL,
                            EdstrFunc);
    r.Ymin = r.Ymax + 5;
    r.Ymax = r.Ymin + SM_GetSystemFontHeight() + 4;
    strcpy(string, "Now is the winter of our discontent.");
    e3 = SM_CreateEditstring(w,
                            &r,
                            "Third test string",
                            128,
                            NULL,
                            EdstrFunc);
    SM_SetEditstringGroup(e, 1);
    SM_SetEditstringGroup(e2, 1);
    SM_SetEditstringGroup(e3, 1);
    /*
    ** Event loop...
    */
    while (True) {
        ev = SM_GetNextEvent();
        msg = SM_ProcessEvent(ev);
        if (msg == KEYPRESS) {
            SM_Exit(NULL);
        }
    }
}


int EdstrFunc(EditstringType *es, EventType *ev)
{
    ev->ASCII = toupper(ev->ASCII);
    sound(100);
    delay(10);
    nosound();
    return 0;
}


