/*
** smutil.h
**
** Header for private, device-dependent utility routines.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
*/

#ifndef SMUTIL_H
#define SMUTIL_H

/*
#include "smtypes.h"
#include "smwindow.h"
*/

#ifdef MW3
#include <grconst.h>
#else
#include <metawndo.h>
#endif

/*
** Function prototypes
*/
void        Beep(void);
rect       *ConditionRect(WindowType *w, rect *r);
void        SM_PtDeviceToWindow(WindowType *w, int xo, int yo, int *x, int *y);
void        EraseBox(ColorType *color, RectType *rt);
int         ErrMessages(void);
void        fatal(char *msg);
void        FontError(int n, char *font);
int         FrameBox(ColorType *color, RectType *rt);

#ifndef MEM_DEBUG
void       *getmem(unsigned int size);
#endif

void        HighlightRect(ColorType *u, ColorType *d, RectType *r);
int         InstallBreakHandler(void);
void        InvHighlightRect(ColorType *u, ColorType *d, RectType *r);
void        NormalizeRect(rect *r);
void        RectLocal2Device(WindowType *w, RectType *s, RectType *d);
rect       *RectType2Rect(rect *m, RectType *r);
RectType   *Rect2RectType(RectType *m, rect *r);
RectType   *ResolveVirtualRect(WindowType *w, RectType *rt);
void        RestoreHandlers(void);
int         RestoreUnder(RectType *r, unsigned char *buf);
unsigned char *SaveUnder(RectType *r);
void        SculptBox(ColorType *face_color,
                      ColorType *up_bevel_color,
                      ColorType *down_bevel_color,
                      RectType  *box);
void        SculptOval(ColorType *face_color,
                      ColorType *up_bevel_color,
                      ColorType *down_bevel_color,
                      RectType  *box);
void        StringInRect(RectType *r,
                         char *s,
                         int  valign,
                         int  halign,
                         ColorType *backcolor,
                         ColorType *color);
void        UnhighlightRect(RectType *r, ColorType *color);
void        Warning(char *msg);
RectType   *WindowClip(WindowType *w, RectType *r, RectType *old);

#endif
/* */



