/*
** smrotlis.h
**
** Header file for mutiple selector gadget
**
** Copyright 1994 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
** All rights reserved
*/

#ifndef SMMULTI_H
#define SMMULTI_H

#include    "smwindow.h"
#include    "smbutton.h"
#include    "smlabel.h"
#include    "smgraph.h"

typedef struct {
    GadgetType  *gadget;                /* Superclass gadget                */
    char        **list;                 /* List of strings to display       */
    int         nlist;                  /* Number of items in the list      */
    int         current;                /* Current string                   */
    int         align;                  /* Left, right, center alignment    */
    ButtonType  *upbutton;              /* Scroll up                        */
    ButtonType  *downbutton;            /* Scroll down                      */
    LabelType   *label;                 /* Display of selected string       */
    int         (*f)();                 /* Application function             */
    void        *data;                  /* Application data                 */
} RotatelistType;

RotatelistType *SM_CreateRotatelist(WindowType   *w,
                                   RectType     *r,
                                   char         **list,
                                   int          align,
                                   int          (*f)(),
                                   void         *data);
int DrawRotatelist(GadgetType *g);
int SM_GetRotatelistSelected(RotatelistType *rl);
char *SM_GetRotatelistString(RotatelistType *rl);
int SM_SetRotatelistList(RotatelistType *rl, char **list);
int SM_SetRotatelistSelected(RotatelistType *rl, int n);
int DestroyRotatelist(GadgetType *g);
int RotatelistProc(GadgetType *g, EventType *ev);
void *SM_GetRotatelistData(RotatelistType *rl);
void SM_SetRotatelistData(RotatelistType *rl, void *d);

#endif

