/*
** smeventd.h
**
** Header file for device-dependent utility routines for TWS event handling
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** 22 May 1992
** Original verison
*/

#ifndef SMEVENTD_H
#define SMEVENTD_H

#include "smeventp.h"                   /* Event type definitions           */
#include "smwindow.h"                   /* Window type definitions          */

#define CLOCKINTERRUPT  0x08            /* Clock interrupt                  */


/*
** Function prototypes
*/
int     AddEvent(
            BackgroundProcType f,       /* User background function         */
            WindowType *w,              /* Parent window                    */
            EventFlagsType fl);         /* Event mask for background proc   */
int     CallUserBackgroundProcs(WindowType *w, EventType *event);
int     CheckControls(EventType *event);
int     CheckPanelControls(EventType *ev);
int     FreeBackgroundProcs(void);
int     InitBackgroundProcs(void);
void    smInitEventQueue(void);
int     RemoveBackgroundProc(BackgroundProcIDType i);
void    StopEventQueue(void);


typedef struct {
    EventType   *queue;
    int         head, tail, count;
} EventQueueType;



/*
** Event queue function prototypes
*/
int     AddClockEvent(void);            /* Add a clock event to the queue   */
void    InitEventQueue();               /* Initializes the TWS event queue  */
int     GetEvent(EventType *ev);        /* Get event from TWS queue         */
void    CloseEventQueue(void);
void    CloseBackgroundProcs(void);


#endif
