/*
** smdraw.h
**
** Header file for window element drawing routines
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** Tue  06-30-1992
** Original version
*/

#ifndef SMDRAW_H
#define SMDRAW_H

#include "smwindow.h"                   /* Window definitions               */
#include "smcolor.h"

void DrawAppTitle(void);
void DrawBorders(WindowType *w);
void DrawIconWindow(WindowType *w);
void DrawMenu(ColorType *face_color,
               ColorType *up_bevel_color,
               ColorType *down_bevel_color,
               WindowType *w);
void DrawTitlebar(WindowType *w);
int  DrawWindow(WindowType *w);
void DrawControls(WindowType *w);
int  DrawWorkspace(WindowType *w);
int  EmptyWindow(WindowType *w);
int  RedrawWindow(WindowType *w);
void RefreshGadgets(WindowType *w);
int  ResizeWindow(WindowType *w);
void RestoreContent(WindowType *win);
void SaveContent(WindowType *win);

#endif






