/*
** smbutton.h
**
** Public header file for button gadget.
**
** Copyright 1992, 1993 by
** Dean Clark
** PO Box 37464
** Albuquerque, NM  87176
**
** Revision history:
**
** 1 Mar 1992
** Original version
**
** 14 Sept 1992
** Revised based on 'generic' gadget type. Specific gadgets only need
** their unique functionality; common functionality is provided by
** generic gadget 'superclass'.
*/

#ifndef SMBUTTON_H
#define SMBUTTON_H

#include "smgadget.h"
#include "smpixmap.h"
/*
** Type definitions
*/

/*
** Button action function
*/
typedef struct _but {
    GadgetType  *gadget;                /* 'Superclass' gadget              */
    char        *label;                 /* Text for button interior         */
    ColorType   *color;                 /* Button face color                */
    ColorType   *pcolor;                /* Button face color when pushed    */
    ColorType   *up_bevel_color;        /* Bevel colors                     */
    ColorType   *down_bevel_color;
    ColorType   *labelcolor;            /* Color for text label             */
    ColorType   *plabelcolor;           /* Color for text label when pushed */
    void        *data;                  /* User-specified data for button   */
    PixmapType  *pixmap;                /* Button pixmap                    */
    int         active;                 /* if TRUE button is active         */
    int         isdefault;              /* if TRUE button activate by Enter */
    int         pushed;                 /* If True button is pushed in      */
    int         (*graphproc)(struct _but *);    /* Draw in the button       */
} ButtonType;

/*
** Function prototypes
*/
void        SM_ActivateButton(ButtonType *b);
ButtonType *SM_CreateButton(WindowType  *w,
                            RectType    *r,
                            char        *label,
                            void        *data,
                            int         (*action)());
void        SM_DeactivateButton(ButtonType *b);
int         SM_DestroyButton(ButtonType *b);
int         SM_GetButtonActive(ButtonType *b);
ColorType  *SM_GetButtonColor(ButtonType *b);
void       *SM_GetButtonData(ButtonType *b);
int         SM_GetButtonIsdefault(ButtonType *b);
char       *SM_GetButtonLabel(ButtonType *b);
ColorType  *SM_GetButtonLabelcolor(ButtonType *b);
PixmapType *SM_GetButtonPixmap(ButtonType *b);
int         SM_SetButtonActive(ButtonType *b, int a);
ColorType  *SM_SetButtonColor(ButtonType *b, ColorType *c);
int         SM_SetButtonData(ButtonType *b, void *data);
int         SM_SetButtonGraphproc(ButtonType *b, int (*f)());
int         SM_SetButtonIsdefault(ButtonType *b, int i);
int         SM_SetButtonLabel(ButtonType *b, char *label);
void        SM_SetButtonPixmap(ButtonType *b, PixmapType *p);
int         SM_SetButtonProc(ButtonType *b, int (*proc)());
int         SM_SetButtonRect(ButtonType *b, RectType *r);


#endif

